package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import static org.hansken.plugin.extraction.util.ArgChecks.argNotNull;

import org.hansken.plugin.extraction.api.ExtractionPlugin;
import org.hansken.plugin.extraction.api.SearchOptions;
import org.hansken.plugin.extraction.api.SearchResult;
import org.hansken.plugin.extraction.api.SearchScope;
import org.hansken.plugin.extraction.api.SearchSortOption;
import org.hansken.plugin.extraction.api.TraceSearcher;

import java.util.List;
import java.util.concurrent.ExecutionException;

/**
 * Proxy implementation for the server side of the {@link ExtractionPlugin extraction plugin} framework. It
 * delegates calls through gRPC (see {@link GrpcFacade}) to retrieve traces from the client side.
 */
public class TraceSearcherProxy implements TraceSearcher {
    private final GrpcFacade _facade;

    public TraceSearcherProxy(final GrpcFacade facade) {
        _facade = argNotNull("facade", facade);
    }

    @Override
    public SearchResult search(final String query, final int count) throws InterruptedException, ExecutionException {
        return search(query, count, SearchOptions.DEFAULT);
    }

    @Override
    public SearchResult search(final String query, final int count, final SearchOptions options) throws InterruptedException, ExecutionException {
        return search(query, count, options.scope(), options.start(), options.sort());
    }

    @Override
    public SearchResult search(final String query, final int count, final SearchScope scope, final int start, final List<SearchSortOption> sort) throws InterruptedException, ExecutionException {
        return _facade.searchTraces(query, count, scope, start, sort);
    }
}
