/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.hansken.extraction.plugin.grpc.RpcSearchRequest;
import org.hansken.extraction.plugin.grpc.RpcSearchScope;
import org.hansken.plugin.extraction.api.BatchSearchResult;
import org.hansken.plugin.extraction.api.SearchResult;
import org.hansken.plugin.extraction.api.SearchScope;
import org.hansken.plugin.extraction.api.SearchSortOption;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.BatchedSearchResult;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class BatchedSearchResultTest {
    private static final List<SearchSortOption> SORT = List.of();
    private static final SearchScope SCOPE = SearchScope.IMAGE;
    private static final String QUERY = "foo";
    private GrpcFacade _facade;

    BatchedSearchResultTest() {
    }

    @BeforeEach
    void setUp() {
        this._facade = (GrpcFacade)Mockito.mock(GrpcFacade.class);
    }

    @Test
    void testSingleBatchWithoutCount() {
        int count = -1;
        boolean start = false;
        Any result = BatchedSearchResultTest.setUpTraceResults(25, 25);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result);
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, -1, SCOPE, 0, SORT);
        List list = batchedSearchResult.getTraces().toList();
        Assertions.assertEquals((int)25, (int)list.size());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((GrpcFacade)Mockito.verify((Object)this._facade)).call((Message)messageCaptor.capture());
        Message value = (Message)messageCaptor.getValue();
        BatchedSearchResultTest.assertRpcRequest(value, 50, 0);
    }

    @Test
    void testSingleBatchWithCount() {
        int count = 2;
        boolean start = false;
        Any result = BatchedSearchResultTest.setUpTraceResults(2, 25);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result);
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, 2, SCOPE, 0, SORT);
        List list = batchedSearchResult.getTraces().toList();
        Assertions.assertEquals((int)2, (int)list.size());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((GrpcFacade)Mockito.verify((Object)this._facade)).call((Message)messageCaptor.capture());
        Message value = (Message)messageCaptor.getValue();
        BatchedSearchResultTest.assertRpcRequest(value, 2, 0);
    }

    @Test
    void testSingleBatchWithLowerCountThanTotalResults() {
        int count = 2;
        boolean start = false;
        Any result = BatchedSearchResultTest.setUpTraceResults(1, 1);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result);
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, 2, SCOPE, 0, SORT);
        List list = batchedSearchResult.getTraces().toList();
        Assertions.assertEquals((int)1, (int)list.size());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((GrpcFacade)Mockito.verify((Object)this._facade)).call((Message)messageCaptor.capture());
        Message value = (Message)messageCaptor.getValue();
        BatchedSearchResultTest.assertRpcRequest(value, 2, 0);
    }

    @Test
    void testSingleBatchWithCountAndStart() {
        int count = 2;
        int start = 3;
        Any result = BatchedSearchResultTest.setUpTraceResults(2, 25);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result);
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, 2, SCOPE, 3, SORT);
        List list = batchedSearchResult.getTraces().toList();
        Assertions.assertEquals((int)2, (int)list.size());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((GrpcFacade)Mockito.verify((Object)this._facade)).call((Message)messageCaptor.capture());
        Message value = (Message)messageCaptor.getValue();
        BatchedSearchResultTest.assertRpcRequest(value, 2, 3);
    }

    @Test
    void testMultipleBatchesWithoutCount() {
        int count = -1;
        boolean start = false;
        Any result1 = BatchedSearchResultTest.setUpTraceResults(50, 125);
        Any result2 = BatchedSearchResultTest.setUpTraceResults(50, 125);
        Any result3 = BatchedSearchResultTest.setUpTraceResults(25, 125);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result1, (Object[])new Any[]{result2, result3});
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, -1, SCOPE, 0, SORT);
        List list = batchedSearchResult.getTraces().toList();
        Assertions.assertEquals((int)125, (int)list.size());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((GrpcFacade)Mockito.verify((Object)this._facade, (VerificationMode)Mockito.times((int)3))).call((Message)messageCaptor.capture());
        List allValues = messageCaptor.getAllValues();
        BatchedSearchResultTest.assertRpcRequest((Message)allValues.get(0), 50, 0);
        BatchedSearchResultTest.assertRpcRequest((Message)allValues.get(1), 50, 50);
        BatchedSearchResultTest.assertRpcRequest((Message)allValues.get(2), 25, 100);
    }

    @Test
    void testMultipleBatchesWithCount() {
        int count = 60;
        boolean start = false;
        Any result1 = BatchedSearchResultTest.setUpTraceResults(50, 75);
        Any result2 = BatchedSearchResultTest.setUpTraceResults(10, 75);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result1, (Object[])new Any[]{result2});
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, 60, SCOPE, 0, SORT);
        List list = batchedSearchResult.getTraces().toList();
        Assertions.assertEquals((int)60, (int)list.size());
        ArgumentCaptor messageCaptor = ArgumentCaptor.forClass(Message.class);
        ((GrpcFacade)Mockito.verify((Object)this._facade, (VerificationMode)Mockito.times((int)2))).call((Message)messageCaptor.capture());
        List allValues = messageCaptor.getAllValues();
        BatchedSearchResultTest.assertRpcRequest((Message)allValues.get(0), 50, 0);
        BatchedSearchResultTest.assertRpcRequest((Message)allValues.get(1), 10, 50);
    }

    @Test
    void testTotalHitsWithStreaming() {
        int count = -1;
        boolean start = false;
        Any result = BatchedSearchResultTest.setUpTraceResults(50, 100000);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result);
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, -1, SCOPE, 0, SORT);
        batchedSearchResult.getTraces().toList();
        long totalHits = batchedSearchResult.getTotalHits();
        Assertions.assertEquals((long)100000L, (long)totalHits);
        ((GrpcFacade)Mockito.verify((Object)this._facade, (VerificationMode)Mockito.times((int)2000))).call((Message)ArgumentMatchers.any());
    }

    @Test
    void testTotalHitsWithoutStreaming() {
        int count = -1;
        boolean start = false;
        Any result = BatchedSearchResultTest.setUpTraceResults(50, 100000);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result);
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, -1, SCOPE, 0, SORT);
        long totalHits = batchedSearchResult.getTotalHits();
        Assertions.assertEquals((long)100000L, (long)totalHits);
        ((GrpcFacade)Mockito.verify((Object)this._facade, (VerificationMode)Mockito.times((int)1))).call((Message)ArgumentMatchers.any());
    }

    @Test
    void testExceedsElasticsearchLimit() {
        int count = -1;
        boolean start = false;
        Any result = BatchedSearchResultTest.setUpTraceResults(50, 100001);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result);
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, -1, SCOPE, 0, SORT);
        IllegalStateException illegalStateException = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> batchedSearchResult.getTraces().toList());
        Assertions.assertEquals((Object)"Search request offset must not exceed the Elasticsearch limit of 100.000.", (Object)illegalStateException.getMessage());
    }

    @Test
    void testAdvanceSpliteratorToTriggerNewSpliterator() {
        int count = -1;
        boolean start = false;
        Any result = BatchedSearchResultTest.setUpTraceResults(50, 50);
        Mockito.when((Object)this._facade.call((Message)ArgumentMatchers.any(Message.class))).thenReturn((Object)result);
        BatchedSearchResult batchedSearchResult = new BatchedSearchResult(this._facade, QUERY, -1, SCOPE, 0, SORT);
        Stream firstStream = batchedSearchResult.getTraces();
        firstStream.findFirst();
        Stream secondStream = batchedSearchResult.getTraces();
        Assertions.assertNotSame((Object)firstStream, (Object)secondStream);
    }

    private static Any setUpTraceResults(int numberOfResults, int totalResults) {
        SearchTrace[] traces = new SearchTrace[numberOfResults];
        for (int i = 0; i < numberOfResults; ++i) {
            SearchTrace trace = (SearchTrace)Mockito.mock(SearchTrace.class);
            Mockito.when((Object)trace.get((String)ArgumentMatchers.any(String.class))).thenReturn((Object)String.valueOf(i));
            Mockito.when((Object)trace.traceId()).thenReturn((Object)"0");
            Mockito.when((Object)trace.types()).thenReturn(Set.of("file", "document"));
            traces[i] = trace;
        }
        BatchSearchResult result = new BatchSearchResult((long)totalResults);
        result.setTraces(traces);
        return Any.pack((Message)Pack.searchResult((SearchResult)result));
    }

    private static void assertRpcRequest(Message value, int count, int start) {
        RpcSearchRequest rpcRequest = (RpcSearchRequest)Unpack.any((Any)Any.pack((Message)value), RpcSearchRequest.class);
        Assertions.assertEquals((int)count, (int)rpcRequest.getCount(), (String)"Unexpected count");
        Assertions.assertEquals((Object)QUERY, (Object)rpcRequest.getQuery(), (String)"Unexpected query");
        Assertions.assertEquals((Object)RpcSearchScope.Image, (Object)rpcRequest.getScope(), (String)"Unexpected scope");
        Assertions.assertEquals((int)start, (int)rpcRequest.getStart(), (String)"Unexpected start");
        Assertions.assertEquals(List.of(), (Object)rpcRequest.getSortList(), (String)"Unexpected sort list");
    }
}

