/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.function.Supplier;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.commons.lang3.StringUtils;
import org.hansken.plugin.extraction.api.BaseExtractionPlugin;
import org.hansken.plugin.extraction.api.PluginInfo;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.hansken.plugin.extraction.runtime.grpc.server.ExtractionPluginServer;

public final class ExtractionPluginServerMain {
    private static final int DEFAULT_PORT_NUMBER = 8999;

    private ExtractionPluginServerMain() {
    }

    public static void runMain(Supplier<BaseExtractionPlugin> pluginSupplier, String[] args) {
        try {
            ExtractionPluginServerMain.run(pluginSupplier, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void run(Supplier<BaseExtractionPlugin> pluginSupplier, String[] args) throws Exception {
        Namespace arguments = ExtractionPluginServerMain.parseArguments(pluginSupplier, args);
        String outputName = arguments.getString("labels_filename");
        if (StringUtils.isNotBlank((CharSequence)outputName)) {
            ExtractionPluginServerMain.writePluginInfoProperties(pluginSupplier.get().pluginInfo(), outputName);
            return;
        }
        try (ExtractionPluginServer plugin = ExtractionPluginServerMain.runNonBlocking(pluginSupplier, arguments);){
            try {
                plugin.blockUntilShutdown();
            }
            catch (InterruptedException e) {
                plugin.close();
                Thread.currentThread().interrupt();
                throw e;
            }
        }
    }

    static ExtractionPluginServer runNonBlocking(Supplier<BaseExtractionPlugin> pluginSupplier, Namespace arguments) throws Exception {
        Integer maximumWorkers = pluginSupplier.get().pluginInfo().resources().maximumWorkers();
        Integer workers = maximumWorkers == null ? arguments.getInt("workers") : maximumWorkers;
        return ExtractionPluginServer.serve((int)arguments.getInt("port"), (int)workers, pluginSupplier);
    }

    private static ArgumentParser createArgParser(Supplier<BaseExtractionPlugin> pluginSupplier) {
        PluginInfo pluginInfo = pluginSupplier.get().pluginInfo();
        ArgumentParser parser = ArgumentParsers.newFor((String)pluginInfo.name()).build().defaultHelp(true).description(pluginInfo.description());
        parser.addArgument(new String[]{"-l", "--labels-filename"}).metavar(new String[]{"labels-filename"}).help("Writes plugin labels to a specified file, or to stdout if -- is passed");
        parser.addArgument(new String[]{"-p", "--port"}).metavar(new String[]{"port"}).type(Integer.class).setDefault((Object)8999).help("Port where the extraction plugin will be served");
        parser.addArgument(new String[]{"-w", "--workers"}).metavar(new String[]{"workers"}).type(Integer.class).setDefault((Object)12).help("The number of concurrent workers(i.e. traces that can be processed). Default value is 12");
        return parser;
    }

    static Namespace parseArguments(Supplier<BaseExtractionPlugin> pluginSupplier, String[] args) {
        ArgumentParser parser = ExtractionPluginServerMain.createArgParser(pluginSupplier);
        Namespace arguments = null;
        try {
            arguments = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        return arguments;
    }

    private static void writePluginInfoProperties(PluginInfo pluginInfo, String outputName) throws IOException {
        try (FileOutputStream output = new FileOutputStream(outputName);){
            ExtractionPluginServerMain.writePluginInfoProperties(pluginInfo, output);
        }
    }

    static void writePluginInfoProperties(PluginInfo pluginInfo, OutputStream outputStream) throws IOException {
        Properties properties = new Properties();
        properties.put("org.hansken.plugin-info.id", pluginInfo.id().toString());
        properties.put("org.hansken.plugin-info.id-domain", pluginInfo.id().domain());
        properties.put("org.hansken.plugin-info.id-category", pluginInfo.id().category());
        properties.put("org.hansken.plugin-info.id-name", pluginInfo.id().name());
        properties.put("org.hansken.plugin-info.version", pluginInfo.pluginVersion());
        properties.put("org.hansken.plugin-info.api-version", VersionUtil.getApiVersion());
        properties.put("org.hansken.plugin-info.description", pluginInfo.description());
        properties.put("org.hansken.plugin-info.webpage", pluginInfo.webpageUrl());
        properties.put("org.hansken.plugin-info.deferred-iterations", Integer.toString(pluginInfo.deferredIterations()));
        properties.put("org.hansken.plugin-info.matcher", pluginInfo.hqlMatcher());
        properties.put("org.hansken.plugin-info.license", pluginInfo.license());
        properties.put("org.hansken.plugin-info.maturity-level", pluginInfo.maturityLevel().name());
        properties.put("org.hansken.plugin-info.author-name", pluginInfo.author().name());
        properties.put("org.hansken.plugin-info.author-organisation", pluginInfo.author().organisation());
        properties.put("org.hansken.plugin-info.author-email", pluginInfo.author().email());
        if (pluginInfo.resources() != null) {
            Float maxCpu = pluginInfo.resources().maximumCpu();
            properties.put("org.hansken.plugin-info.resource-max-cpu", maxCpu == null ? "" : Float.toString(maxCpu.floatValue()));
            Integer maxMem = pluginInfo.resources().maximumMemory();
            properties.put("org.hansken.plugin-info.resource-max-mem", maxMem == null ? "" : Integer.toString(maxMem));
        }
        properties.store(outputStream, "Labels for extraction plugin image");
    }
}

