package org.hansken.plugin.extraction.runtime.grpc.server.logging;

import static org.apache.logging.log4j.core.config.ConfigurationFactory.CATEGORY;

import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Order;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;

/**
 * Creates a XmlConfiguration from a xml file.
 * The order is 50 so this {@link XmlConfigurationFactory} factory is loaded before {@link org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory} is loaded.
 */
@Plugin(name = "XmlConfigurationFactory", category = CATEGORY)
@Order(50)
public class XmlConfigurationFactory extends BaseConfigurationFactory {

    @Override
    protected String[] getSupportedTypes() {
        return new String[]{".xml", "*"};
    }

    /**
     * Returns the Configuration.
     *
     * @param loggerContext The logger context
     * @param source The ConfigurationSource
     * @return The Configuration
     */
    @Override
    public Configuration getConfiguration(final LoggerContext loggerContext, final ConfigurationSource source) {
        return new XmlConfiguration(loggerContext, source);
    }
}
