/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc;

import com.google.protobuf.Any;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hansken.extraction.plugin.grpc.RpcEnrichTrace;
import org.hansken.extraction.plugin.grpc.RpcFinish;
import org.hansken.extraction.plugin.grpc.RpcRange;
import org.hansken.extraction.plugin.grpc.RpcRangedTransformation;
import org.hansken.extraction.plugin.grpc.RpcTrace;
import org.hansken.extraction.plugin.grpc.RpcTransformation;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.transformations.DataRange;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.api.transformations.RangedDataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class GrpcFacadeTest {
    GrpcFacadeTest() {
    }

    @Test
    void cacheTraceEnrichment() throws Exception {
        StreamObserver outgoing = (StreamObserver)Mockito.mock(StreamObserver.class);
        GrpcFacade facade = new GrpcFacade(new ArrayBlockingQueue(1), outgoing, Integer.MAX_VALUE);
        List<Trace.Tracelet> tracelets = List.of(new Trace.Tracelet("identity", List.of(new Trace.TraceletProperty("identity.id", (Object)"bla@blah.com"))));
        Map<String, List<DataTransformation>> transformations = this.createTransformations();
        facade.enrichTrace("0", Set.of("raw"), Map.of("raw.size", 256L), tracelets, transformations);
        facade.enrichTrace("0", Set.of("file"), Map.of("file.name", "key.txt"), tracelets, transformations);
        ((StreamObserver)Mockito.verify((Object)outgoing, (VerificationMode)Mockito.never())).onNext((Object)((Any)ArgumentMatchers.any()));
        facade.finishProcessing(0.0);
        ArgumentCaptor sent = ArgumentCaptor.forClass(Any.class);
        ((StreamObserver)Mockito.verify((Object)outgoing)).onNext((Object)((Any)sent.capture()));
        Any any = (Any)sent.getValue();
        Assertions.assertTrue((boolean)any.is(RpcFinish.class));
        List actions = ((RpcFinish)any.unpack(RpcFinish.class)).getUpdate().getActionsList();
        GrpcFacadeTest.assertRpcEnrichment((Any)actions.get(0), Set.of("raw"), Map.of("raw.size", 256L), transformations);
        GrpcFacadeTest.assertRpcEnrichment((Any)actions.get(1), Set.of("file"), Map.of("file.name", "key.txt"), transformations);
    }

    private Map<String, List<DataTransformation>> createTransformations() {
        HashMap<String, List<DataTransformation>> transformations = new HashMap<String, List<DataTransformation>>();
        ArrayList<RangedDataTransformation> rangedTransformations = new ArrayList<RangedDataTransformation>();
        rangedTransformations.add(new RangedDataTransformation(new DataRange[]{new DataRange(1L, 2L), new DataRange(3L, 4L)}));
        rangedTransformations.add(new RangedDataTransformation(new DataRange[]{new DataRange(5L, 6L)}));
        transformations.put("raw", rangedTransformations);
        return transformations;
    }

    private static void assertRpcEnrichment(Any any, Set<String> types, Map<String, Object> properties, Map<String, List<DataTransformation>> transformations) throws Exception {
        Assertions.assertTrue((boolean)any.is(RpcEnrichTrace.class));
        RpcTrace trace = ((RpcEnrichTrace)any.unpack(RpcEnrichTrace.class)).getTrace();
        MatcherAssert.assertThat(Set.copyOf(trace.getTypesList()), (Matcher)Matchers.is((Matcher)Matchers.equalTo(types)));
        MatcherAssert.assertThat((Object)trace.getPropertiesCount(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)properties.size())));
        trace.getPropertiesList().forEach(property -> MatcherAssert.assertThat((Object)Unpack.primitive((Any)property.getValue()), (Matcher)Matchers.is((Matcher)Matchers.equalTo(properties.get(property.getName())))));
        trace.getTransformationsList().forEach(rpcTransformation -> {
            Assertions.assertTrue((boolean)transformations.containsKey(rpcTransformation.getDataType()));
            GrpcFacadeTest.assertTransformations((List)transformations.get(rpcTransformation.getDataType()), rpcTransformation.getTransformationsList());
        });
    }

    private static void assertTransformations(List<DataTransformation> transformations, List<RpcTransformation> rpcTransformations) {
        for (int i = 0; i < transformations.size(); ++i) {
            GrpcFacadeTest.assertRangedTransformation((RangedDataTransformation)transformations.get(i), rpcTransformations.get(i).getRangedTransformation());
        }
    }

    private static void assertRangedTransformation(RangedDataTransformation transformation, RpcRangedTransformation rpcTransformation) {
        for (int i = 0; i < transformation.getRanges().size(); ++i) {
            GrpcFacadeTest.assertDataRange((DataRange)transformation.getRanges().get(i), rpcTransformation.getRanges(i));
        }
    }

    private static void assertDataRange(DataRange dataRange, RpcRange rpcRange) {
        Assertions.assertEquals((long)dataRange.getLength(), (long)rpcRange.getLength());
        Assertions.assertEquals((long)dataRange.getOffset(), (long)rpcRange.getOffset());
    }
}

