/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hansken.extraction.plugin.grpc.RpcRandomAccessDataMeta;
import org.hansken.extraction.plugin.grpc.RpcSearchTrace;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.runtime.grpc.common.Checks;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.ImmutableTraceProxy;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.RandomAccessDataProxy;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.TraceProxy;
import org.hansken.plugin.extraction.util.ArgChecks;

public class SearchTraceProxy
extends ImmutableTraceProxy
implements SearchTrace {
    private final List<RpcRandomAccessDataMeta> _data;
    private final GrpcFacade _facade;

    SearchTraceProxy(Set<String> types, Map<String, Object> properties, String traceId, List<RpcRandomAccessDataMeta> data, GrpcFacade facade) {
        super(types, properties, traceId);
        this._data = (List)ArgChecks.argNotNull((String)"data", data);
        this._facade = facade;
    }

    public static SearchTraceProxy fromRpc(RpcSearchTrace trace, GrpcFacade facade) {
        ArgChecks.argNotNull((String)"trace", (Object)trace);
        HashSet<String> types = new HashSet<String>((Collection<String>)trace.getTypesList());
        Map<String, Object> properties = TraceProxy.getProperties(trace.getPropertiesList());
        String traceId = trace.getId();
        List data = trace.getDataList();
        return new SearchTraceProxy(types, properties, traceId, data, facade);
    }

    public RandomAccessData getData(String dataType) {
        Checks.assertIsNotMeta((String)dataType);
        RpcRandomAccessDataMeta rpcData = this._data.stream().filter(data -> data.getType().equals(dataType)).findFirst().orElseThrow(() -> new IllegalStateException("No data of type " + dataType));
        return RandomAccessDataProxy.fromRpc(rpcData, (String)this.get("uid"), this._facade);
    }

    public List<String> getDataTypes() {
        return this._data.stream().map(RpcRandomAccessDataMeta::getType).collect(Collectors.toList());
    }
}

