/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/monitoring.proto

package org.hansken.ep.shade.com.google.api;

/**
 *
 *
 * <pre>
 * Monitoring configuration of the service.
 *
 * The example below shows how to configure monitored resources and metrics
 * for monitoring. In the example, a monitored resource and two metrics are
 * defined. The `library.googleapis.com/book/returned_count` metric is sent
 * to both producer and consumer projects, whereas the
 * `library.googleapis.com/book/num_overdue` metric is only sent to the
 * consumer project.
 *
 *     monitored_resources:
 *     - type: library.googleapis.com/Branch
 *       display_name: "Library Branch"
 *       description: "A branch of a library."
 *       launch_stage: GA
 *       labels:
 *       - key: resource_container
 *         description: "The Cloud container (ie. project id) for the Branch."
 *       - key: location
 *         description: "The location of the library branch."
 *       - key: branch_id
 *         description: "The id of the branch."
 *     metrics:
 *     - name: library.googleapis.com/book/returned_count
 *       display_name: "Books Returned"
 *       description: "The count of books that have been returned."
 *       launch_stage: GA
 *       metric_kind: DELTA
 *       value_type: INT64
 *       unit: "1"
 *       labels:
 *       - key: customer_id
 *         description: "The id of the customer."
 *     - name: library.googleapis.com/book/num_overdue
 *       display_name: "Books Overdue"
 *       description: "The current number of overdue books."
 *       launch_stage: GA
 *       metric_kind: GAUGE
 *       value_type: INT64
 *       unit: "1"
 *       labels:
 *       - key: customer_id
 *         description: "The id of the customer."
 *     monitoring:
 *       producer_destinations:
 *       - monitored_resource: library.googleapis.com/Branch
 *         metrics:
 *         - library.googleapis.com/book/returned_count
 *       consumer_destinations:
 *       - monitored_resource: library.googleapis.com/Branch
 *         metrics:
 *         - library.googleapis.com/book/returned_count
 *         - library.googleapis.com/book/num_overdue
 * </pre>
 *
 * Protobuf type {@code google.api.Monitoring}
 */
public final class Monitoring extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:org.hansken.ep.shade.google.api.Monitoring)
    MonitoringOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Monitoring.newBuilder() to construct.
  private Monitoring(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Monitoring() {
    producerDestinations_ = java.util.Collections.emptyList();
    consumerDestinations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Monitoring();
  }

  public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_descriptor;
  }

  @java.lang.Override
  protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.hansken.ep.shade.com.google.api.Monitoring.class, org.hansken.ep.shade.com.google.api.Monitoring.Builder.class);
  }

  public interface MonitoringDestinationOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:org.hansken.ep.shade.google.api.Monitoring.MonitoringDestination)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][org.hansken.ep.shade.google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     *
     * @return The monitoredResource.
     */
    java.lang.String getMonitoredResource();
    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][org.hansken.ep.shade.google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     *
     * @return The bytes for monitoredResource.
     */
    org.hansken.ep.shade.com.google.protobuf.ByteString getMonitoredResourceBytes();

    /**
     *
     *
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in
     * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return A list containing the metrics.
     */
    java.util.List<java.lang.String> getMetricsList();
    /**
     *
     *
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in
     * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return The count of metrics.
     */
    int getMetricsCount();
    /**
     *
     *
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in
     * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The metrics at the given index.
     */
    java.lang.String getMetrics(int index);
    /**
     *
     *
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in
     * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metrics at the given index.
     */
    org.hansken.ep.shade.com.google.protobuf.ByteString getMetricsBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Configuration of a specific monitoring destination (the producer project
   * or the consumer project).
   * </pre>
   *
   * Protobuf type {@code google.api.Monitoring.MonitoringDestination}
   */
  public static final class MonitoringDestination extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:org.hansken.ep.shade.google.api.Monitoring.MonitoringDestination)
      MonitoringDestinationOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MonitoringDestination.newBuilder() to construct.
    private MonitoringDestination(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MonitoringDestination() {
      monitoredResource_ = "";
      metrics_ = org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MonitoringDestination();
    }

    public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.MonitoringProto
          .internal_static_google_api_Monitoring_MonitoringDestination_descriptor;
    }

    @java.lang.Override
    protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.MonitoringProto
          .internal_static_google_api_Monitoring_MonitoringDestination_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.class,
              org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder.class);
    }

    public static final int MONITORED_RESOURCE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object monitoredResource_ = "";
    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][org.hansken.ep.shade.google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     *
     * @return The monitoredResource.
     */
    @java.lang.Override
    public java.lang.String getMonitoredResource() {
      java.lang.Object ref = monitoredResource_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        monitoredResource_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The monitored resource type. The type must be defined in
     * [Service.monitored_resources][org.hansken.ep.shade.google.api.Service.monitored_resources]
     * section.
     * </pre>
     *
     * <code>string monitored_resource = 1;</code>
     *
     * @return The bytes for monitoredResource.
     */
    @java.lang.Override
    public org.hansken.ep.shade.com.google.protobuf.ByteString getMonitoredResourceBytes() {
      java.lang.Object ref = monitoredResource_;
      if (ref instanceof java.lang.String) {
        org.hansken.ep.shade.com.google.protobuf.ByteString b =
            org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        monitoredResource_ = b;
        return b;
      } else {
        return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
      }
    }

    public static final int METRICS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList metrics_ =
        org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in
     * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return A list containing the metrics.
     */
    public org.hansken.ep.shade.com.google.protobuf.ProtocolStringList getMetricsList() {
      return metrics_;
    }
    /**
     *
     *
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in
     * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @return The count of metrics.
     */
    public int getMetricsCount() {
      return metrics_.size();
    }
    /**
     *
     *
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in
     * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The metrics at the given index.
     */
    public java.lang.String getMetrics(int index) {
      return metrics_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Types of the metrics to report to this monitoring destination.
     * Each type must be defined in
     * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
     * </pre>
     *
     * <code>repeated string metrics = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the metrics at the given index.
     */
    public org.hansken.ep.shade.com.google.protobuf.ByteString getMetricsBytes(int index) {
      return metrics_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(org.hansken.ep.shade.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(monitoredResource_)) {
        org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 1, monitoredResource_);
      }
      for (int i = 0; i < metrics_.size(); i++) {
        org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.writeString(output, 2, metrics_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.isStringEmpty(monitoredResource_)) {
        size += org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.computeStringSize(1, monitoredResource_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < metrics_.size(); i++) {
          dataSize += computeStringSizeNoTag(metrics_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getMetricsList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.api.Monitoring.MonitoringDestination)) {
        return super.equals(obj);
      }
      org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination other =
          (org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination) obj;

      if (!getMonitoredResource().equals(other.getMonitoredResource())) return false;
      if (!getMetricsList().equals(other.getMetricsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MONITORED_RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getMonitoredResource().hashCode();
      if (getMetricsCount() > 0) {
        hash = (37 * hash) + METRICS_FIELD_NUMBER;
        hash = (53 * hash) + getMetricsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(
        java.nio.ByteBuffer data) throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(
        java.nio.ByteBuffer data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(
        org.hansken.ep.shade.com.google.protobuf.ByteString data)
        throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(
        org.hansken.ep.shade.com.google.protobuf.ByteString data,
        org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(byte[] data)
        throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(
        byte[] data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(
        java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseDelimitedFrom(
        java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(
        org.hansken.ep.shade.com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination parseFrom(
        org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
        org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration of a specific monitoring destination (the producer project
     * or the consumer project).
     * </pre>
     *
     * Protobuf type {@code google.api.Monitoring.MonitoringDestination}
     */
    public static final class Builder
        extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:org.hansken.ep.shade.google.api.Monitoring.MonitoringDestination)
        com.google.api.Monitoring.MonitoringDestinationOrBuilder {
      public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.api.MonitoringProto
            .internal_static_google_api_Monitoring_MonitoringDestination_descriptor;
      }

      @java.lang.Override
      protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.api.MonitoringProto
            .internal_static_google_api_Monitoring_MonitoringDestination_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.class,
                org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder.class);
      }

      // Construct using com.google.api.Monitoring.MonitoringDestination.newBuilder()
      private Builder() {}

      private Builder(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        monitoredResource_ = "";
        metrics_ = org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.api.MonitoringProto
            .internal_static_google_api_Monitoring_MonitoringDestination_descriptor;
      }

      @java.lang.Override
      public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination getDefaultInstanceForType() {
        return com.google.api.Monitoring.MonitoringDestination.getDefaultInstance();
      }

      @java.lang.Override
      public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination build() {
        org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination buildPartial() {
        org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination result =
            new com.google.api.Monitoring.MonitoringDestination(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.monitoredResource_ = monitoredResource_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          metrics_.makeImmutable();
          result.metrics_ = metrics_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(org.hansken.ep.shade.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(org.hansken.ep.shade.com.google.protobuf.Message other) {
        if (other instanceof com.google.api.Monitoring.MonitoringDestination) {
          return mergeFrom((org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination other) {
        if (other == org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.getDefaultInstance())
          return this;
        if (!other.getMonitoredResource().isEmpty()) {
          monitoredResource_ = other.monitoredResource_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ |= 0x00000002;
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
          org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  monitoredResource_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureMetricsIsMutable();
                  metrics_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object monitoredResource_ = "";
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][org.hansken.ep.shade.google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @return The monitoredResource.
       */
      public java.lang.String getMonitoredResource() {
        java.lang.Object ref = monitoredResource_;
        if (!(ref instanceof java.lang.String)) {
          org.hansken.ep.shade.com.google.protobuf.ByteString bs = (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          monitoredResource_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][org.hansken.ep.shade.google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @return The bytes for monitoredResource.
       */
      public org.hansken.ep.shade.com.google.protobuf.ByteString getMonitoredResourceBytes() {
        java.lang.Object ref = monitoredResource_;
        if (ref instanceof String) {
          org.hansken.ep.shade.com.google.protobuf.ByteString b =
              org.hansken.ep.shade.com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          monitoredResource_ = b;
          return b;
        } else {
          return (org.hansken.ep.shade.com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][org.hansken.ep.shade.google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @param value The monitoredResource to set.
       * @return This builder for chaining.
       */
      public Builder setMonitoredResource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        monitoredResource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][org.hansken.ep.shade.google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMonitoredResource() {
        monitoredResource_ = getDefaultInstance().getMonitoredResource();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The monitored resource type. The type must be defined in
       * [Service.monitored_resources][org.hansken.ep.shade.google.api.Service.monitored_resources]
       * section.
       * </pre>
       *
       * <code>string monitored_resource = 1;</code>
       *
       * @param value The bytes for monitoredResource to set.
       * @return This builder for chaining.
       */
      public Builder setMonitoredResourceBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        monitoredResource_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList metrics_ =
          org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureMetricsIsMutable() {
        if (!metrics_.isModifiable()) {
          metrics_ = new com.google.protobuf.LazyStringArrayList(metrics_);
        }
        bitField0_ |= 0x00000002;
      }
      /**
       *
       *
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in
       * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @return A list containing the metrics.
       */
      public org.hansken.ep.shade.com.google.protobuf.ProtocolStringList getMetricsList() {
        metrics_.makeImmutable();
        return metrics_;
      }
      /**
       *
       *
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in
       * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @return The count of metrics.
       */
      public int getMetricsCount() {
        return metrics_.size();
      }
      /**
       *
       *
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in
       * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The metrics at the given index.
       */
      public java.lang.String getMetrics(int index) {
        return metrics_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in
       * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the metrics at the given index.
       */
      public org.hansken.ep.shade.com.google.protobuf.ByteString getMetricsBytes(int index) {
        return metrics_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in
       * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The metrics to set.
       * @return This builder for chaining.
       */
      public Builder setMetrics(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in
       * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param value The metrics to add.
       * @return This builder for chaining.
       */
      public Builder addMetrics(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in
       * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param values The metrics to add.
       * @return This builder for chaining.
       */
      public Builder addAllMetrics(java.lang.Iterable<java.lang.String> values) {
        ensureMetricsIsMutable();
        org.hansken.ep.shade.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in
       * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetrics() {
        metrics_ = org.hansken.ep.shade.com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Types of the metrics to report to this monitoring destination.
       * Each type must be defined in
       * [Service.metrics][org.hansken.ep.shade.google.api.Service.metrics] section.
       * </pre>
       *
       * <code>repeated string metrics = 2;</code>
       *
       * @param value The bytes of the metrics to add.
       * @return This builder for chaining.
       */
      public Builder addMetricsBytes(org.hansken.ep.shade.com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureMetricsIsMutable();
        metrics_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:org.hansken.ep.shade.google.api.Monitoring.MonitoringDestination)
    }

    // @@protoc_insertion_point(class_scope:org.hansken.ep.shade.google.api.Monitoring.MonitoringDestination)
    private static final org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.api.Monitoring.MonitoringDestination();
    }

    public static org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final org.hansken.ep.shade.com.google.protobuf.Parser<MonitoringDestination> PARSER =
        new com.google.protobuf.AbstractParser<MonitoringDestination>() {
          @java.lang.Override
          public MonitoringDestination parsePartialFrom(
              org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
              org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (org.hansken.ep.shade.com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static org.hansken.ep.shade.com.google.protobuf.Parser<MonitoringDestination> parser() {
      return PARSER;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.protobuf.Parser<MonitoringDestination> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PRODUCER_DESTINATIONS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination> producerDestinations_;
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination>
      getProducerDestinationsList() {
    return producerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>
      getProducerDestinationsOrBuilderList() {
    return producerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public int getProducerDestinationsCount() {
    return producerDestinations_.size();
  }
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination getProducerDestinations(int index) {
    return producerDestinations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the producer project.
   * There can be multiple producer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder getProducerDestinationsOrBuilder(
      int index) {
    return producerDestinations_.get(index);
  }

  public static final int CONSUMER_DESTINATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination> consumerDestinations_;
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination>
      getConsumerDestinationsList() {
    return consumerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>
      getConsumerDestinationsOrBuilderList() {
    return consumerDestinations_;
  }
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public int getConsumerDestinationsCount() {
    return consumerDestinations_.size();
  }
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination getConsumerDestinations(int index) {
    return consumerDestinations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Monitoring configurations for sending metrics to the consumer project.
   * There can be multiple consumer destinations. A monitored resource type may
   * appear in multiple monitoring destinations if different aggregations are
   * needed for different sets of metrics associated with that monitored
   * resource type. A monitored resource and metric pair may only be used once
   * in the Monitoring configuration.
   * </pre>
   *
   * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder getConsumerDestinationsOrBuilder(
      int index) {
    return consumerDestinations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.hansken.ep.shade.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < producerDestinations_.size(); i++) {
      output.writeMessage(1, producerDestinations_.get(i));
    }
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      output.writeMessage(2, consumerDestinations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < producerDestinations_.size(); i++) {
      size +=
          org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeMessageSize(1, producerDestinations_.get(i));
    }
    for (int i = 0; i < consumerDestinations_.size(); i++) {
      size +=
          org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeMessageSize(2, consumerDestinations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.Monitoring)) {
      return super.equals(obj);
    }
    org.hansken.ep.shade.com.google.api.Monitoring other = (org.hansken.ep.shade.com.google.api.Monitoring) obj;

    if (!getProducerDestinationsList().equals(other.getProducerDestinationsList())) return false;
    if (!getConsumerDestinationsList().equals(other.getConsumerDestinationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getProducerDestinationsCount() > 0) {
      hash = (37 * hash) + PRODUCER_DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getProducerDestinationsList().hashCode();
    }
    if (getConsumerDestinationsCount() > 0) {
      hash = (37 * hash) + CONSUMER_DESTINATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getConsumerDestinationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(java.nio.ByteBuffer data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(
      java.nio.ByteBuffer data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(org.hansken.ep.shade.com.google.protobuf.ByteString data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(
      org.hansken.ep.shade.com.google.protobuf.ByteString data,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(byte[] data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(
      byte[] data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseDelimitedFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(org.hansken.ep.shade.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring parseFrom(
      org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.hansken.ep.shade.com.google.api.Monitoring prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Monitoring configuration of the service.
   *
   * The example below shows how to configure monitored resources and metrics
   * for monitoring. In the example, a monitored resource and two metrics are
   * defined. The `library.googleapis.com/book/returned_count` metric is sent
   * to both producer and consumer projects, whereas the
   * `library.googleapis.com/book/num_overdue` metric is only sent to the
   * consumer project.
   *
   *     monitored_resources:
   *     - type: library.googleapis.com/Branch
   *       display_name: "Library Branch"
   *       description: "A branch of a library."
   *       launch_stage: GA
   *       labels:
   *       - key: resource_container
   *         description: "The Cloud container (ie. project id) for the Branch."
   *       - key: location
   *         description: "The location of the library branch."
   *       - key: branch_id
   *         description: "The id of the branch."
   *     metrics:
   *     - name: library.googleapis.com/book/returned_count
   *       display_name: "Books Returned"
   *       description: "The count of books that have been returned."
   *       launch_stage: GA
   *       metric_kind: DELTA
   *       value_type: INT64
   *       unit: "1"
   *       labels:
   *       - key: customer_id
   *         description: "The id of the customer."
   *     - name: library.googleapis.com/book/num_overdue
   *       display_name: "Books Overdue"
   *       description: "The current number of overdue books."
   *       launch_stage: GA
   *       metric_kind: GAUGE
   *       value_type: INT64
   *       unit: "1"
   *       labels:
   *       - key: customer_id
   *         description: "The id of the customer."
   *     monitoring:
   *       producer_destinations:
   *       - monitored_resource: library.googleapis.com/Branch
   *         metrics:
   *         - library.googleapis.com/book/returned_count
   *       consumer_destinations:
   *       - monitored_resource: library.googleapis.com/Branch
   *         metrics:
   *         - library.googleapis.com/book/returned_count
   *         - library.googleapis.com/book/num_overdue
   * </pre>
   *
   * Protobuf type {@code google.api.Monitoring}
   */
  public static final class Builder extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:org.hansken.ep.shade.google.api.Monitoring)
      com.google.api.MonitoringOrBuilder {
    public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_descriptor;
    }

    @java.lang.Override
    protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.hansken.ep.shade.com.google.api.Monitoring.class, org.hansken.ep.shade.com.google.api.Monitoring.Builder.class);
    }

    // Construct using com.google.api.Monitoring.newBuilder()
    private Builder() {}

    private Builder(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (producerDestinationsBuilder_ == null) {
        producerDestinations_ = java.util.Collections.emptyList();
      } else {
        producerDestinations_ = null;
        producerDestinationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
      } else {
        consumerDestinations_ = null;
        consumerDestinationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.MonitoringProto.internal_static_google_api_Monitoring_descriptor;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.Monitoring getDefaultInstanceForType() {
      return com.google.api.Monitoring.getDefaultInstance();
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.Monitoring build() {
      org.hansken.ep.shade.com.google.api.Monitoring result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.Monitoring buildPartial() {
      org.hansken.ep.shade.com.google.api.Monitoring result = new com.google.api.Monitoring(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(org.hansken.ep.shade.com.google.api.Monitoring result) {
      if (producerDestinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          producerDestinations_ = java.util.Collections.unmodifiableList(producerDestinations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.producerDestinations_ = producerDestinations_;
      } else {
        result.producerDestinations_ = producerDestinationsBuilder_.build();
      }
      if (consumerDestinationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          consumerDestinations_ = java.util.Collections.unmodifiableList(consumerDestinations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.consumerDestinations_ = consumerDestinations_;
      } else {
        result.consumerDestinations_ = consumerDestinationsBuilder_.build();
      }
    }

    private void buildPartial0(org.hansken.ep.shade.com.google.api.Monitoring result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.hansken.ep.shade.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.hansken.ep.shade.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.Monitoring) {
        return mergeFrom((org.hansken.ep.shade.com.google.api.Monitoring) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.hansken.ep.shade.com.google.api.Monitoring other) {
      if (other == org.hansken.ep.shade.com.google.api.Monitoring.getDefaultInstance()) return this;
      if (producerDestinationsBuilder_ == null) {
        if (!other.producerDestinations_.isEmpty()) {
          if (producerDestinations_.isEmpty()) {
            producerDestinations_ = other.producerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureProducerDestinationsIsMutable();
            producerDestinations_.addAll(other.producerDestinations_);
          }
          onChanged();
        }
      } else {
        if (!other.producerDestinations_.isEmpty()) {
          if (producerDestinationsBuilder_.isEmpty()) {
            producerDestinationsBuilder_.dispose();
            producerDestinationsBuilder_ = null;
            producerDestinations_ = other.producerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            producerDestinationsBuilder_ =
                org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getProducerDestinationsFieldBuilder()
                    : null;
          } else {
            producerDestinationsBuilder_.addAllMessages(other.producerDestinations_);
          }
        }
      }
      if (consumerDestinationsBuilder_ == null) {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinations_.isEmpty()) {
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureConsumerDestinationsIsMutable();
            consumerDestinations_.addAll(other.consumerDestinations_);
          }
          onChanged();
        }
      } else {
        if (!other.consumerDestinations_.isEmpty()) {
          if (consumerDestinationsBuilder_.isEmpty()) {
            consumerDestinationsBuilder_.dispose();
            consumerDestinationsBuilder_ = null;
            consumerDestinations_ = other.consumerDestinations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            consumerDestinationsBuilder_ =
                org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConsumerDestinationsFieldBuilder()
                    : null;
          } else {
            consumerDestinationsBuilder_.addAllMessages(other.consumerDestinations_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
        org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination m =
                    input.readMessage(
                        org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.parser(),
                        extensionRegistry);
                if (producerDestinationsBuilder_ == null) {
                  ensureProducerDestinationsIsMutable();
                  producerDestinations_.add(m);
                } else {
                  producerDestinationsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination m =
                    input.readMessage(
                        org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.parser(),
                        extensionRegistry);
                if (consumerDestinationsBuilder_ == null) {
                  ensureConsumerDestinationsIsMutable();
                  consumerDestinations_.add(m);
                } else {
                  consumerDestinationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination> producerDestinations_ =
        java.util.Collections.emptyList();

    private void ensureProducerDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        producerDestinations_ =
            new java.util.ArrayList<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination>(
                producerDestinations_);
        bitField0_ |= 0x00000001;
      }
    }

    private org.hansken.ep.shade.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Monitoring.MonitoringDestination,
            org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder,
            org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>
        producerDestinationsBuilder_;

    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination>
        getProducerDestinationsList() {
      if (producerDestinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(producerDestinations_);
      } else {
        return producerDestinationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public int getProducerDestinationsCount() {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.size();
      } else {
        return producerDestinationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination getProducerDestinations(int index) {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.get(index);
      } else {
        return producerDestinationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder setProducerDestinations(
        int index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.set(index, value);
        onChanged();
      } else {
        producerDestinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder setProducerDestinations(
        int index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(value);
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        int index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination value) {
      if (producerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(index, value);
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addProducerDestinations(
        int index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        producerDestinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder addAllProducerDestinations(
        java.lang.Iterable<? extends org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination> values) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        org.hansken.ep.shade.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, producerDestinations_);
        onChanged();
      } else {
        producerDestinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder clearProducerDestinations() {
      if (producerDestinationsBuilder_ == null) {
        producerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        producerDestinationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public Builder removeProducerDestinations(int index) {
      if (producerDestinationsBuilder_ == null) {
        ensureProducerDestinationsIsMutable();
        producerDestinations_.remove(index);
        onChanged();
      } else {
        producerDestinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder getProducerDestinationsBuilder(
        int index) {
      return getProducerDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder
        getProducerDestinationsOrBuilder(int index) {
      if (producerDestinationsBuilder_ == null) {
        return producerDestinations_.get(index);
      } else {
        return producerDestinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public java.util.List<? extends org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>
        getProducerDestinationsOrBuilderList() {
      if (producerDestinationsBuilder_ != null) {
        return producerDestinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(producerDestinations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder
        addProducerDestinationsBuilder() {
      return getProducerDestinationsFieldBuilder()
          .addBuilder(org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder addProducerDestinationsBuilder(
        int index) {
      return getProducerDestinationsFieldBuilder()
          .addBuilder(index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the producer project.
     * There can be multiple producer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination producer_destinations = 1;</code>
     */
    public java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder>
        getProducerDestinationsBuilderList() {
      return getProducerDestinationsFieldBuilder().getBuilderList();
    }

    private org.hansken.ep.shade.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Monitoring.MonitoringDestination,
            org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder,
            org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>
        getProducerDestinationsFieldBuilder() {
      if (producerDestinationsBuilder_ == null) {
        producerDestinationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.Monitoring.MonitoringDestination,
                org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder,
                org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>(
                producerDestinations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        producerDestinations_ = null;
      }
      return producerDestinationsBuilder_;
    }

    private java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination> consumerDestinations_ =
        java.util.Collections.emptyList();

    private void ensureConsumerDestinationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        consumerDestinations_ =
            new java.util.ArrayList<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination>(
                consumerDestinations_);
        bitField0_ |= 0x00000002;
      }
    }

    private org.hansken.ep.shade.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Monitoring.MonitoringDestination,
            org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder,
            org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>
        consumerDestinationsBuilder_;

    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination>
        getConsumerDestinationsList() {
      if (consumerDestinationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      } else {
        return consumerDestinationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public int getConsumerDestinationsCount() {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.size();
      } else {
        return consumerDestinationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination getConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);
      } else {
        return consumerDestinationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder setConsumerDestinations(
        int index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder setConsumerDestinations(
        int index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.set(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        int index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination value) {
      if (consumerDestinationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, value);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addConsumerDestinations(
        int index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder builderForValue) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.add(index, builderForValue.build());
        onChanged();
      } else {
        consumerDestinationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder addAllConsumerDestinations(
        java.lang.Iterable<? extends org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination> values) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        org.hansken.ep.shade.com.google.protobuf.AbstractMessageLite.Builder.addAll(values, consumerDestinations_);
        onChanged();
      } else {
        consumerDestinationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder clearConsumerDestinations() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        consumerDestinationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public Builder removeConsumerDestinations(int index) {
      if (consumerDestinationsBuilder_ == null) {
        ensureConsumerDestinationsIsMutable();
        consumerDestinations_.remove(index);
        onChanged();
      } else {
        consumerDestinationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder getConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder
        getConsumerDestinationsOrBuilder(int index) {
      if (consumerDestinationsBuilder_ == null) {
        return consumerDestinations_.get(index);
      } else {
        return consumerDestinationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public java.util.List<? extends org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>
        getConsumerDestinationsOrBuilderList() {
      if (consumerDestinationsBuilder_ != null) {
        return consumerDestinationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(consumerDestinations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder
        addConsumerDestinationsBuilder() {
      return getConsumerDestinationsFieldBuilder()
          .addBuilder(org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder addConsumerDestinationsBuilder(
        int index) {
      return getConsumerDestinationsFieldBuilder()
          .addBuilder(index, org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Monitoring configurations for sending metrics to the consumer project.
     * There can be multiple consumer destinations. A monitored resource type may
     * appear in multiple monitoring destinations if different aggregations are
     * needed for different sets of metrics associated with that monitored
     * resource type. A monitored resource and metric pair may only be used once
     * in the Monitoring configuration.
     * </pre>
     *
     * <code>repeated .google.api.Monitoring.MonitoringDestination consumer_destinations = 2;</code>
     */
    public java.util.List<org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder>
        getConsumerDestinationsBuilderList() {
      return getConsumerDestinationsFieldBuilder().getBuilderList();
    }

    private org.hansken.ep.shade.com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.Monitoring.MonitoringDestination,
            org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder,
            org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>
        getConsumerDestinationsFieldBuilder() {
      if (consumerDestinationsBuilder_ == null) {
        consumerDestinationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.Monitoring.MonitoringDestination,
                org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestination.Builder,
                org.hansken.ep.shade.com.google.api.Monitoring.MonitoringDestinationOrBuilder>(
                consumerDestinations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        consumerDestinations_ = null;
      }
      return consumerDestinationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:org.hansken.ep.shade.google.api.Monitoring)
  }

  // @@protoc_insertion_point(class_scope:org.hansken.ep.shade.google.api.Monitoring)
  private static final org.hansken.ep.shade.com.google.api.Monitoring DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.Monitoring();
  }

  public static org.hansken.ep.shade.com.google.api.Monitoring getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.hansken.ep.shade.com.google.protobuf.Parser<Monitoring> PARSER =
      new com.google.protobuf.AbstractParser<Monitoring>() {
        @java.lang.Override
        public Monitoring parsePartialFrom(
            org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
            org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.hansken.ep.shade.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static org.hansken.ep.shade.com.google.protobuf.Parser<Monitoring> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.Parser<Monitoring> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.Monitoring getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
