/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/field_info.proto

package org.hansken.ep.shade.com.google.api;

/**
 *
 *
 * <pre>
 * Rich semantic information of an API field beyond basic typing.
 * </pre>
 *
 * Protobuf type {@code google.api.FieldInfo}
 */
public final class FieldInfo extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:org.hansken.ep.shade.google.api.FieldInfo)
    FieldInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use FieldInfo.newBuilder() to construct.
  private FieldInfo(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FieldInfo() {
    format_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FieldInfo();
  }

  public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.FieldInfoProto.internal_static_google_api_FieldInfo_descriptor;
  }

  @java.lang.Override
  protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.FieldInfoProto.internal_static_google_api_FieldInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            org.hansken.ep.shade.com.google.api.FieldInfo.class, org.hansken.ep.shade.com.google.api.FieldInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The standard format of a field value. The supported formats are all backed
   * by either an RFC defined by the IETF or a Google-defined AIP.
   * </pre>
   *
   * Protobuf enum {@code google.api.FieldInfo.Format}
   */
  public enum Format implements org.hansken.ep.shade.com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default, unspecified value.
     * </pre>
     *
     * <code>FORMAT_UNSPECIFIED = 0;</code>
     */
    FORMAT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Universally Unique Identifier, version 4, value as defined by
     * https://datatracker.ietf.org/doc/html/rfc4122. The value may be
     * normalized to entirely lowercase letters. For example, the value
     * `F47AC10B-58CC-0372-8567-0E02B2C3D479` would be normalized to
     * `f47ac10b-58cc-0372-8567-0e02b2c3d479`.
     * </pre>
     *
     * <code>UUID4 = 1;</code>
     */
    UUID4(1),
    /**
     *
     *
     * <pre>
     * Internet Protocol v4 value as defined by [RFC
     * 791](https://datatracker.ietf.org/doc/html/rfc791). The value may be
     * condensed, with leading zeros in each octet stripped. For example,
     * `001.022.233.040` would be condensed to `1.22.233.40`.
     * </pre>
     *
     * <code>IPV4 = 2;</code>
     */
    IPV4(2),
    /**
     *
     *
     * <pre>
     * Internet Protocol v6 value as defined by [RFC
     * 2460](https://datatracker.ietf.org/doc/html/rfc2460). The value may be
     * normalized to entirely lowercase letters, and zero-padded partial and
     * empty octets. For example, the value `2001:DB8::` would be normalized to
     * `2001:0db8:0:0`.
     * </pre>
     *
     * <code>IPV6 = 3;</code>
     */
    IPV6(3),
    /**
     *
     *
     * <pre>
     * An IP address in either v4 or v6 format as described by the individual
     * values defined herein. See the comments on the IPV4 and IPV6 types for
     * allowed normalizations of each.
     * </pre>
     *
     * <code>IPV4_OR_IPV6 = 4;</code>
     */
    IPV4_OR_IPV6(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default, unspecified value.
     * </pre>
     *
     * <code>FORMAT_UNSPECIFIED = 0;</code>
     */
    public static final int FORMAT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Universally Unique Identifier, version 4, value as defined by
     * https://datatracker.ietf.org/doc/html/rfc4122. The value may be
     * normalized to entirely lowercase letters. For example, the value
     * `F47AC10B-58CC-0372-8567-0E02B2C3D479` would be normalized to
     * `f47ac10b-58cc-0372-8567-0e02b2c3d479`.
     * </pre>
     *
     * <code>UUID4 = 1;</code>
     */
    public static final int UUID4_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Internet Protocol v4 value as defined by [RFC
     * 791](https://datatracker.ietf.org/doc/html/rfc791). The value may be
     * condensed, with leading zeros in each octet stripped. For example,
     * `001.022.233.040` would be condensed to `1.22.233.40`.
     * </pre>
     *
     * <code>IPV4 = 2;</code>
     */
    public static final int IPV4_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Internet Protocol v6 value as defined by [RFC
     * 2460](https://datatracker.ietf.org/doc/html/rfc2460). The value may be
     * normalized to entirely lowercase letters, and zero-padded partial and
     * empty octets. For example, the value `2001:DB8::` would be normalized to
     * `2001:0db8:0:0`.
     * </pre>
     *
     * <code>IPV6 = 3;</code>
     */
    public static final int IPV6_VALUE = 3;
    /**
     *
     *
     * <pre>
     * An IP address in either v4 or v6 format as described by the individual
     * values defined herein. See the comments on the IPV4 and IPV6 types for
     * allowed normalizations of each.
     * </pre>
     *
     * <code>IPV4_OR_IPV6 = 4;</code>
     */
    public static final int IPV4_OR_IPV6_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Format valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Format forNumber(int value) {
      switch (value) {
        case 0:
          return FORMAT_UNSPECIFIED;
        case 1:
          return UUID4;
        case 2:
          return IPV4;
        case 3:
          return IPV6;
        case 4:
          return IPV4_OR_IPV6;
        default:
          return null;
      }
    }

    public static org.hansken.ep.shade.com.google.protobuf.Internal.EnumLiteMap<Format> internalGetValueMap() {
      return internalValueMap;
    }

    private static final org.hansken.ep.shade.com.google.protobuf.Internal.EnumLiteMap<Format> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Format>() {
          public Format findValueByNumber(int number) {
            return Format.forNumber(number);
          }
        };

    public final org.hansken.ep.shade.com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final org.hansken.ep.shade.com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.api.FieldInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final Format[] VALUES = values();

    public static Format valueOf(org.hansken.ep.shade.com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Format(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:org.hansken.ep.shade.google.api.FieldInfo.Format)
  }

  public static final int FORMAT_FIELD_NUMBER = 1;
  private int format_ = 0;
  /**
   *
   *
   * <pre>
   * The standard format of a field value. This does not explicitly configure
   * any API consumer, just documents the API's format for the field it is
   * applied to.
   * </pre>
   *
   * <code>.google.api.FieldInfo.Format format = 1;</code>
   *
   * @return The enum numeric value on the wire for format.
   */
  @java.lang.Override
  public int getFormatValue() {
    return format_;
  }
  /**
   *
   *
   * <pre>
   * The standard format of a field value. This does not explicitly configure
   * any API consumer, just documents the API's format for the field it is
   * applied to.
   * </pre>
   *
   * <code>.google.api.FieldInfo.Format format = 1;</code>
   *
   * @return The format.
   */
  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.FieldInfo.Format getFormat() {
    org.hansken.ep.shade.com.google.api.FieldInfo.Format result = org.hansken.ep.shade.com.google.api.FieldInfo.Format.forNumber(format_);
    return result == null ? com.google.api.FieldInfo.Format.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(org.hansken.ep.shade.com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (format_ != org.hansken.ep.shade.com.google.api.FieldInfo.Format.FORMAT_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, format_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (format_ != org.hansken.ep.shade.com.google.api.FieldInfo.Format.FORMAT_UNSPECIFIED.getNumber()) {
      size += org.hansken.ep.shade.com.google.protobuf.CodedOutputStream.computeEnumSize(1, format_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.FieldInfo)) {
      return super.equals(obj);
    }
    org.hansken.ep.shade.com.google.api.FieldInfo other = (org.hansken.ep.shade.com.google.api.FieldInfo) obj;

    if (format_ != other.format_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + format_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(java.nio.ByteBuffer data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(
      java.nio.ByteBuffer data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(org.hansken.ep.shade.com.google.protobuf.ByteString data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(
      org.hansken.ep.shade.com.google.protobuf.ByteString data,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(byte[] data)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(
      byte[] data, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseDelimitedFrom(
      java.io.InputStream input, org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(org.hansken.ep.shade.com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo parseFrom(
      org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
      org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(org.hansken.ep.shade.com.google.api.FieldInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Rich semantic information of an API field beyond basic typing.
   * </pre>
   *
   * Protobuf type {@code google.api.FieldInfo}
   */
  public static final class Builder extends org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:org.hansken.ep.shade.google.api.FieldInfo)
      com.google.api.FieldInfoOrBuilder {
    public static final org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.FieldInfoProto.internal_static_google_api_FieldInfo_descriptor;
    }

    @java.lang.Override
    protected org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.FieldInfoProto.internal_static_google_api_FieldInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.hansken.ep.shade.com.google.api.FieldInfo.class, org.hansken.ep.shade.com.google.api.FieldInfo.Builder.class);
    }

    // Construct using com.google.api.FieldInfo.newBuilder()
    private Builder() {}

    private Builder(org.hansken.ep.shade.com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      format_ = 0;
      return this;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.FieldInfoProto.internal_static_google_api_FieldInfo_descriptor;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.FieldInfo getDefaultInstanceForType() {
      return com.google.api.FieldInfo.getDefaultInstance();
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.FieldInfo build() {
      org.hansken.ep.shade.com.google.api.FieldInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.FieldInfo buildPartial() {
      org.hansken.ep.shade.com.google.api.FieldInfo result = new com.google.api.FieldInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(org.hansken.ep.shade.com.google.api.FieldInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.format_ = format_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(org.hansken.ep.shade.com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        org.hansken.ep.shade.com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(org.hansken.ep.shade.com.google.protobuf.Message other) {
      if (other instanceof com.google.api.FieldInfo) {
        return mergeFrom((org.hansken.ep.shade.com.google.api.FieldInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(org.hansken.ep.shade.com.google.api.FieldInfo other) {
      if (other == org.hansken.ep.shade.com.google.api.FieldInfo.getDefaultInstance()) return this;
      if (other.format_ != 0) {
        setFormatValue(other.getFormatValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
        org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                format_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int format_ = 0;
    /**
     *
     *
     * <pre>
     * The standard format of a field value. This does not explicitly configure
     * any API consumer, just documents the API's format for the field it is
     * applied to.
     * </pre>
     *
     * <code>.google.api.FieldInfo.Format format = 1;</code>
     *
     * @return The enum numeric value on the wire for format.
     */
    @java.lang.Override
    public int getFormatValue() {
      return format_;
    }
    /**
     *
     *
     * <pre>
     * The standard format of a field value. This does not explicitly configure
     * any API consumer, just documents the API's format for the field it is
     * applied to.
     * </pre>
     *
     * <code>.google.api.FieldInfo.Format format = 1;</code>
     *
     * @param value The enum numeric value on the wire for format to set.
     * @return This builder for chaining.
     */
    public Builder setFormatValue(int value) {
      format_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard format of a field value. This does not explicitly configure
     * any API consumer, just documents the API's format for the field it is
     * applied to.
     * </pre>
     *
     * <code>.google.api.FieldInfo.Format format = 1;</code>
     *
     * @return The format.
     */
    @java.lang.Override
    public org.hansken.ep.shade.com.google.api.FieldInfo.Format getFormat() {
      org.hansken.ep.shade.com.google.api.FieldInfo.Format result = org.hansken.ep.shade.com.google.api.FieldInfo.Format.forNumber(format_);
      return result == null ? com.google.api.FieldInfo.Format.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The standard format of a field value. This does not explicitly configure
     * any API consumer, just documents the API's format for the field it is
     * applied to.
     * </pre>
     *
     * <code>.google.api.FieldInfo.Format format = 1;</code>
     *
     * @param value The format to set.
     * @return This builder for chaining.
     */
    public Builder setFormat(org.hansken.ep.shade.com.google.api.FieldInfo.Format value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      format_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The standard format of a field value. This does not explicitly configure
     * any API consumer, just documents the API's format for the field it is
     * applied to.
     * </pre>
     *
     * <code>.google.api.FieldInfo.Format format = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFormat() {
      bitField0_ = (bitField0_ & ~0x00000001);
      format_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final org.hansken.ep.shade.com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:org.hansken.ep.shade.google.api.FieldInfo)
  }

  // @@protoc_insertion_point(class_scope:org.hansken.ep.shade.google.api.FieldInfo)
  private static final org.hansken.ep.shade.com.google.api.FieldInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.FieldInfo();
  }

  public static org.hansken.ep.shade.com.google.api.FieldInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final org.hansken.ep.shade.com.google.protobuf.Parser<FieldInfo> PARSER =
      new com.google.protobuf.AbstractParser<FieldInfo>() {
        @java.lang.Override
        public FieldInfo parsePartialFrom(
            org.hansken.ep.shade.com.google.protobuf.CodedInputStream input,
            org.hansken.ep.shade.com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (org.hansken.ep.shade.com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (org.hansken.ep.shade.com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static org.hansken.ep.shade.com.google.protobuf.Parser<FieldInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.protobuf.Parser<FieldInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public org.hansken.ep.shade.com.google.api.FieldInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
