/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.test;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.hansken.plugin.extraction.api.RandomAccessData;

public class TestRandomAccessData
implements RandomAccessData {
    protected final long _size;
    protected long _position;

    protected TestRandomAccessData(long size) {
        this._size = size;
        this._position = 0L;
    }

    public static RandomAccessData throwingDataOfSize(long size) {
        return new TestRandomAccessData(size);
    }

    public static RandomAccessData emptyData() {
        return TestRandomAccessData.zeroDataOfSize(0L);
    }

    public static RandomAccessData zeroDataOfSize(long size) {
        return new TestRandomAccessData(size){

            @Override
            public int read(byte[] buffer, int offset, int count) {
                Arrays.fill(buffer, offset, count, (byte)0);
                this.seek(this.position() + (long)count);
                return count;
            }
        };
    }

    public static RandomAccessData binaryData(final byte[] data, String dataType) {
        return new TestRandomAccessData(data.length){

            @Override
            public int read(byte[] buffer, int offset, int count) {
                int shouldRead = Math.toIntExact(Math.min((long)count, this.size() - this.position()));
                System.arraycopy(data, (int)this.position(), buffer, offset, shouldRead);
                this.seek(this.position() + (long)shouldRead);
                return shouldRead;
            }
        };
    }

    public static RandomAccessData textData(String data, String dataType) {
        return TestRandomAccessData.binaryData(data.getBytes(StandardCharsets.UTF_8), dataType);
    }

    public static RandomAccessData concatenatedData(String dataType, RandomAccessData ... datas) throws IllegalArgumentException {
        return Arrays.stream(datas).reduce(TestRandomAccessData.emptyData(), TestRandomAccessData::concatenatedData);
    }

    public static RandomAccessData concatenatedData(final RandomAccessData left, final RandomAccessData right) throws IllegalArgumentException {
        return new TestRandomAccessData(left.size() + right.size()){

            @Override
            public int read(byte[] buffer, int offset, int count) throws IOException {
                int shouldRead;
                int remaining = shouldRead = Math.toIntExact(Math.min((long)count, this.size() - this.position()));
                if (this.position() < left.size()) {
                    left.seek(this.position());
                    int readFromLeft = left.read(buffer, offset, (int)Math.min((long)remaining, left.size() - this.position()));
                    this.seek(this.position() + (long)readFromLeft);
                    remaining -= readFromLeft;
                }
                if (this.position() >= left.size()) {
                    right.seek(this.position() - left.size());
                    int readFromRight = right.read(buffer, offset + (shouldRead - remaining), remaining);
                    this.seek(this.position() + (long)readFromRight);
                }
                return shouldRead;
            }
        };
    }

    public long size() {
        return this._size;
    }

    public long position() {
        return this._position;
    }

    public void seek(long position) {
        this._position = position;
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        throw new IOException(this.getClass().getSimpleName() + " has no read implemented by default");
    }

    public void close() {
    }
}

