/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.ep.shade.io.grpc.internal;

import java.util.concurrent.Executor;
import org.hansken.ep.shade.com.google.common.annotations.VisibleForTesting;
import org.hansken.ep.shade.com.google.common.base.Preconditions;
import org.hansken.ep.shade.com.google.common.util.concurrent.ListenableFuture;
import org.hansken.ep.shade.com.google.common.util.concurrent.SettableFuture;
import org.hansken.ep.shade.io.grpc.CallOptions;
import org.hansken.ep.shade.io.grpc.ClientStreamTracer;
import org.hansken.ep.shade.io.grpc.InternalChannelz;
import org.hansken.ep.shade.io.grpc.InternalLogId;
import org.hansken.ep.shade.io.grpc.Metadata;
import org.hansken.ep.shade.io.grpc.MethodDescriptor;
import org.hansken.ep.shade.io.grpc.Status;
import org.hansken.ep.shade.io.grpc.internal.ClientStream;
import org.hansken.ep.shade.io.grpc.internal.ClientStreamListener;
import org.hansken.ep.shade.io.grpc.internal.ClientTransport;
import org.hansken.ep.shade.io.grpc.internal.FailingClientStream;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret = SettableFuture.create();
        ret.set(null);
        return ret;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

