/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source <a href="https://github.com/google/guava">Guava</a>
 * library.
 *
 * <h2>Contents</h2>
 *
 * The classes in this package that are most commonly useful are:
 *
 * <h3>String utilities</h3>
 *
 * <ul>
 *   <li>{@link Ascii}
 *   <li>{@link CaseFormat}
 *   <li>{@link CharMatcher}
 *   <li>{@link Splitter}
 *   <li>{@link Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 *   <li>{@link Converter}
 *   <li>{@link Equivalence}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 *   <li>{@link Enums}
 *   <li>{@link MoreObjects}
 *   <li>{@link Preconditions}
 *   <li>{@link StandardSystemProperty}
 *   <li>{@link Stopwatch}
 *   <li>{@link Throwables}
 *   <li>{@link Verify}
 * </ul>
 *
 * <h3>The rest</h3>
 *
 * This package also contains some classes with niche use cases (e.g., {@link Utf8} and {@link
 * Defaults}), as well as a number of classes that have been superseded by additions to the JDK.
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package org.hansken.ep.shade.com.google.common.base;

import org.hansken.ep.shade.com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
