package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import org.hansken.plugin.extraction.api.ExtractionPlugin;
import org.hansken.plugin.extraction.api.ImmutableTrace;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import static org.hansken.plugin.extraction.util.ArgChecks.argNotEmpty;
import static org.hansken.plugin.extraction.util.ArgChecks.argNotNull;

/**
 * Proxy implementation for the server side of the {@link ExtractionPlugin extraction plugin} framework. It
 * delegates calls through gRPC (see {@link GrpcFacade}) to the trace currently being processed on the client side.
 * <p>
 * <strong>Note:</strong> this implementation is not thread-safe.
 */
public class ImmutableTraceProxy implements ImmutableTrace {
    private final Set<String> _types;
    private final Map<String, Object> _properties;
    private final String _traceId;

    ImmutableTraceProxy(final Set<String> types, final Map<String, Object> properties, final String traceId) {
        _types = new HashSet<>(argNotNull("types", types));
        _properties = new HashMap<>(argNotNull("properties", properties));
        _traceId = argNotNull("traceId", traceId);
    }

    @Override
    public Set<String> types() {
        return _types;
    }

    @Override
    public Set<String> properties() {
        return _properties.keySet();
    }

    @Override
    public String traceId() {
        return _traceId;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T get(final String name) {
        return (T) _properties.get(argNotEmpty("name", name));
    }
}
