/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.server.proxy;

import java.io.OutputStream;
import java.util.Objects;
import org.hansken.plugin.extraction.runtime.grpc.server.proxy.GrpcFacade;
import org.hansken.plugin.extraction.util.ArgChecks;

class OutputStreamProxy
extends OutputStream {
    private final byte[] _buffer = new byte[1];
    private final String _id;
    private final GrpcFacade _facade;
    private final String _dataType;

    OutputStreamProxy(String id, String dataType, GrpcFacade facade) {
        this._id = ArgChecks.argNotEmpty((String)"id", (String)id);
        this._dataType = ArgChecks.argNotEmpty((String)"dataType", (String)dataType);
        this._facade = (GrpcFacade)ArgChecks.argNotNull((String)"facade", (Object)facade);
        this._facade.beginWritingData(this._id, this._dataType);
    }

    @Override
    public void write(int b) {
        this._buffer[0] = (byte)b;
        this.write(this._buffer, 0, 1);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this._facade.writeData(this._id, this._dataType, buffer, offset, length);
    }

    @Override
    public void close() {
        this._facade.finishWritingData(this._id, this._dataType);
    }
}

