/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.api;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsProcessor;
import nl.minvenj.nfi.flits.api.FlitsResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.io.FileMatchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;

public abstract class Flits {
    public static final String RESULT_FILE_SUFFIX = ".json";
    public static final String INFO_FILE_SUFFIX = ".flits.info";
    static final String ORPHANED_RESULT_FILES_DIRECTORY = "orphanedResultFiles";

    public abstract Path testPath();

    public abstract Path resultPath();

    public abstract FlitsProcessor processor();

    public boolean regenerate() {
        String regenerate = System.getProperty("flits.regenerate");
        return regenerate != null;
    }

    public String pattern() {
        return "glob:**";
    }

    public String resultFileSuffix() {
        return "." + this.processor().name() + RESULT_FILE_SUFFIX;
    }

    @TestFactory
    List<DynamicNode> tests() {
        ArgChecks.argNotNull("testPath", this.testPath());
        ArgChecks.argNotNull("resultPath", this.resultPath());
        ArgChecks.argNotNull("processor", this.processor());
        ArgChecks.argNotNull("pattern", this.pattern());
        Flits.checkPath(this.testPath(), "test");
        if (!this.regenerate()) {
            Flits.checkPath(this.resultPath(), "result");
        }
        BiConsumer<FlitsResult, Path> resultProcessor = this.regenerate() ? this::write : this::compare;
        List<DynamicNode> tests = this.toDynamicNodes(this.testPath(), resultProcessor).collect(Collectors.toList());
        if (tests.isEmpty()) {
            throw new IllegalArgumentException("No testfile found. Did you specify the correct directory or filter?");
        }
        return tests;
    }

    @Test
    public void detectOrphanedResultFiles() {
        try (Stream<Path> files = Files.walk(this.resultPath(), new FileVisitOption[0]);){
            Collection orphanedResultFiles = files.filter(resultPath -> !Files.isDirectory(resultPath, new LinkOption[0])).filter(this::isOrphanedResultFile).collect(Collectors.toList());
            if (this.regenerate() && !orphanedResultFiles.isEmpty()) {
                this.moveOrphanedResultFiles(orphanedResultFiles);
                String reason = "The following orphaned result files were moved to this directory:\n" + this.getOrphanedResultFilesPath() + "/\n\n" + orphanedResultFiles.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining("\n")) + "\n\nPlease verify if the above mentioned files can be deleted and remove the directory.";
                MatcherAssert.assertThat((String)reason, (boolean)orphanedResultFiles.isEmpty());
            } else {
                String listedOrphanedResultFiles = orphanedResultFiles.stream().map(Path::toString).collect(Collectors.joining("\n"));
                String reason = "There are orphaned result files present. The following file(s) should be checked:\n" + listedOrphanedResultFiles;
                MatcherAssert.assertThat((String)reason, (boolean)orphanedResultFiles.isEmpty());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Test
    public void orphanedResultFilesDirectoryShouldNotBePresent() {
        MatcherAssert.assertThat((String)("There should not be an orphaned result files directory present at this location:\n" + this.getOrphanedResultFilesPath()), (boolean)Files.notExists(this.getOrphanedResultFilesPath(), new LinkOption[0]));
    }

    @Test
    public void regenerateShouldBeOff() {
        Assertions.assertFalse((boolean)this.regenerate(), (String)"It is not allowed to (over)write results in production code.");
    }

    public Path getOrphanedResultFilesPath() {
        return this.resultPath().getParent().resolve(ORPHANED_RESULT_FILES_DIRECTORY);
    }

    boolean isOrphanedResultFile(Path resultFilePath) {
        return resultFilePath.getFileName().toString().endsWith(RESULT_FILE_SUFFIX) && !Files.exists(this.expectedTestFilePath(resultFilePath), new LinkOption[0]);
    }

    private Path expectedTestFilePath(Path resultFilePath) {
        Path relativePath;
        Path resultFileName = resultFilePath.getFileName();
        String testFilename = resultFileName.toString();
        if (testFilename.contains(".")) {
            String[] resultFilenameParts = testFilename.split("\\.");
            CharSequence[] resultFilenameWithoutJsonExtension = Arrays.copyOf(resultFilenameParts, resultFilenameParts.length - 2);
            testFilename = String.join((CharSequence)".", resultFilenameWithoutJsonExtension);
        }
        if ((relativePath = this.resultPath().relativize(resultFilePath).getParent()) == null) {
            return this.testPath().resolve(testFilename);
        }
        return this.testPath().resolve(relativePath).resolve(testFilename);
    }

    private void moveOrphanedResultFiles(Collection<Path> orphanedResultFiles) throws IOException {
        Path newOrphanedResultFilesDirectory = Files.createDirectory(this.getOrphanedResultFilesPath(), new FileAttribute[0]);
        for (Path path : orphanedResultFiles) {
            Files.move(path, newOrphanedResultFilesDirectory.resolve(path.getFileName()), new CopyOption[0]);
        }
    }

    private Stream<DynamicNode> toDynamicNodes(Path directory, BiConsumer<FlitsResult, Path> resultProcessor) {
        try {
            return this.walkDirectory(directory).filter(path -> !directory.equals(path)).filter(path -> Files.isDirectory(path, new LinkOption[0]) || Flits.isTestFile(path)).map(path -> this.toDynamicNode((Path)path, resultProcessor)).filter(Objects::nonNull);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Stream<Path> walkDirectory(Path directory) throws IOException {
        return Files.walk(directory, 1, new FileVisitOption[0]);
    }

    private DynamicNode toDynamicNode(Path path, BiConsumer<FlitsResult, Path> libraryResultProcessor) {
        String testName = path.getFileName().toString();
        if (Files.isDirectory(path, new LinkOption[0])) {
            List dynamicNodes = this.toDynamicNodes(path, libraryResultProcessor).collect(Collectors.toList());
            if (!dynamicNodes.isEmpty()) {
                return DynamicContainer.dynamicContainer((String)testName, dynamicNodes);
            }
        } else if (this.getPathFilter(this.pattern()).test(path)) {
            return DynamicTest.dynamicTest((String)testName, () -> this.processTestFile(path, libraryResultProcessor));
        }
        return null;
    }

    private Predicate<Path> getPathFilter(String pattern) {
        PathMatcher pathMatcher = this.testPath().getFileSystem().getPathMatcher(pattern);
        return path -> pathMatcher.matches(this.testPath().relativize((Path)path));
    }

    static boolean isTestFile(Path path) {
        return !path.toString().endsWith(INFO_FILE_SUFFIX);
    }

    private static void checkPath(Path path, String typeOfPath) {
        String root = "Root ";
        if (path.toString().isEmpty()) {
            throw new IllegalArgumentException("Root " + typeOfPath + " path should not be empty.");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Root " + typeOfPath + " path should refer to an existing path, got: " + path);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Root " + typeOfPath + " path should be a directory, got: " + path);
        }
    }

    private void processTestFile(Path testFilePath, BiConsumer<FlitsResult, Path> libraryResultProcessor) {
        Path relativeTestFilePath = this.testPath().relativize(testFilePath);
        Path resultFilePath = this.resultPath().resolve(relativeTestFilePath + this.resultFileSuffix());
        try {
            FlitsProcessor processor = this.processor();
            Optional<FlitsResult> result = processor.process(testFilePath, relativeTestFilePath);
            result.ifPresentOrElse(libraryResult -> libraryResultProcessor.accept((FlitsResult)libraryResult, resultFilePath), () -> MatcherAssert.assertThat((String)"Result should not exist, because the library did not process the test file.", (Object)resultFilePath.toFile(), (Matcher)Matchers.not((Matcher)FileMatchers.anExistingFile())));
        }
        catch (IOException e) {
            throw new UncheckedIOException("error loading test file: " + testFilePath, e);
        }
    }

    private void compare(FlitsResult actual, Path resultFilePath) {
        try {
            actual.validate(this.processor().validator(), resultFilePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void write(FlitsResult actual, Path resultFilePath) {
        try {
            actual.generate(this.processor().generator(), resultFilePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

