/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.api.result;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsResult;
import nl.minvenj.nfi.flits.api.FlitsResultGenerator;
import nl.minvenj.nfi.flits.api.FlitsResultValidator;
import nl.minvenj.nfi.flits.api.result.EmptyResult;

public class CombinedResult
implements FlitsResult {
    private final List<FlitsResult> _results;

    CombinedResult(List<FlitsResult> results) {
        ArgChecks.argNotEmpty("results", results);
        this._results = results;
    }

    public static FlitsResult of(List<FlitsResult> results) {
        ArgChecks.argNotNull("results", results);
        return results.isEmpty() ? new EmptyResult() : new CombinedResult(results);
    }

    @Override
    public void validate(FlitsResultValidator validator, Path inputPath) throws IOException {
        validator.validate(this, inputPath);
    }

    @Override
    public void generate(FlitsResultGenerator generator, Path outputPath) throws IOException {
        generator.generate(this, outputPath);
    }

    public List<FlitsResult> results() {
        return this._results;
    }
}

