/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.base;

import com.fasterxml.jackson.core.JsonGenerator;
import nl.minvenj.nfi.flits.api.FlitsResult;
import nl.minvenj.nfi.flits.api.result.CombinedResult;
import nl.minvenj.nfi.flits.api.result.EmptyResult;
import nl.minvenj.nfi.flits.api.result.ThrowableResult;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.EmptyResultJson;
import nl.minvenj.nfi.flits.base.FlitsResultJson;
import nl.minvenj.nfi.flits.base.ThrowableResultJson;
import nl.minvenj.nfi.flits.serialize.TraceToJson;
import nl.minvenj.nfi.flits.util.ExceptionUtil;

class CombinedResultJson
implements FlitsResultJson {
    private final CombinedResult _combinedResult;
    private final TraceToJson _traceToJson;

    CombinedResultJson(CombinedResult combinedResult, TraceToJson traceToJson) {
        this._combinedResult = combinedResult;
        this._traceToJson = traceToJson;
    }

    @Override
    public void toGenerator(JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> {
            if (this._combinedResult.results().size() == 1) {
                this.writeToGenerator(this._combinedResult.results().get(0), generator);
            } else {
                generator.writeStartArray();
                this._combinedResult.results().forEach(flitsResult -> this.writeToGenerator((FlitsResult)flitsResult, generator));
                generator.writeEndArray();
                generator.flush();
            }
        });
    }

    private void writeToGenerator(FlitsResult result, JsonGenerator generator) {
        if (result instanceof TraceResult) {
            this._traceToJson.writeToGenerator(((TraceResult)result).traces(), generator);
        } else if (result instanceof ThrowableResult) {
            new ThrowableResultJson((ThrowableResult)result).toGenerator(generator);
        } else if (result instanceof EmptyResult) {
            new EmptyResultJson((EmptyResult)result).toGenerator(generator);
        } else {
            throw new IllegalArgumentException("No support for: " + result.getClass());
        }
    }
}

