/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.base;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsResultGenerator;
import nl.minvenj.nfi.flits.api.result.CombinedResult;
import nl.minvenj.nfi.flits.api.result.EmptyResult;
import nl.minvenj.nfi.flits.api.result.ThrowableResult;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.CombinedResultJson;
import nl.minvenj.nfi.flits.base.EmptyResultJson;
import nl.minvenj.nfi.flits.base.ThrowableResultJson;
import nl.minvenj.nfi.flits.serialize.TraceToJson;

public class DefaultResultGenerator
implements FlitsResultGenerator {
    private final TraceToJson _traceJson;

    public DefaultResultGenerator(TraceToJson traceJson) {
        this._traceJson = ArgChecks.argNotNull("traceJson", traceJson);
    }

    @Override
    public void generate(EmptyResult result, Path outputPath) throws IOException {
        this.write(new EmptyResultJson(result).json(), outputPath);
    }

    @Override
    public void generate(ThrowableResult result, Path outputPath) throws IOException {
        this.write(new ThrowableResultJson(result).json(), outputPath);
    }

    @Override
    public void generate(CombinedResult result, Path outputPath) throws IOException {
        String json = new CombinedResultJson(result, this._traceJson).json();
        this.write(json, outputPath);
    }

    @Override
    public void generate(TraceResult result, Path outputPath) throws IOException {
        if (!Files.exists(outputPath, new LinkOption[0])) {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        }
        this._traceJson.writeToPath(result.traces(), outputPath);
    }

    protected void write(String result, Path output) throws IOException {
        if (!Files.exists(output, new LinkOption[0])) {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
        }
        Files.write(output, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

