/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hansken.ep.shade.com.google.protobuf.Any;
import org.hansken.extraction.plugin.grpc.RpcBatchUpdate;
import org.hansken.extraction.plugin.grpc.RpcBeginChild;
import org.hansken.extraction.plugin.grpc.RpcBeginDataStream;
import org.hansken.extraction.plugin.grpc.RpcEnrichTrace;
import org.hansken.extraction.plugin.grpc.RpcFinish;
import org.hansken.extraction.plugin.grpc.RpcFinishChild;
import org.hansken.extraction.plugin.grpc.RpcFinishDataStream;
import org.hansken.extraction.plugin.grpc.RpcNull;
import org.hansken.extraction.plugin.grpc.RpcPartialFinishWithError;
import org.hansken.extraction.plugin.grpc.RpcRead;
import org.hansken.extraction.plugin.grpc.RpcSearchRequest;
import org.hansken.extraction.plugin.grpc.RpcTrace;
import org.hansken.extraction.plugin.grpc.RpcTracelet;
import org.hansken.extraction.plugin.grpc.RpcWriteDataStream;
import org.hansken.plugin.extraction.api.SearchResult;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginDataReader;
import org.hansken.plugin.extraction.runtime.grpc.client.StreamTransferState;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractionPluginGrpcAdapter {
    static final String CURRENT_PROCESS_TRACE_MARKER = "0";
    private static final Logger LOG = LoggerFactory.getLogger(ExtractionPluginGrpcAdapter.class);
    private final Deque<TraceState> _traceStack = new ArrayDeque<TraceState>();
    private final ExecutorService _executor = Executors.newCachedThreadPool();
    private final ExtractionPluginDataReader _reader;
    private Throwable _error;
    private final TraceSearcher _searcher;

    public ExtractionPluginGrpcAdapter(ClientTrace trace, ClientDataContext context, ExtractionPluginDataReader reader) {
        this(trace, context, reader, null);
    }

    public ExtractionPluginGrpcAdapter(ClientTrace trace, ClientDataContext context, ExtractionPluginDataReader reader, TraceSearcher searcher) {
        ArgChecks.argNotNull((String)"trace", (Object)trace);
        ArgChecks.argNotNull((String)"context", (Object)context);
        this._traceStack.push(this.rootState(trace));
        this._searcher = searcher;
        this._reader = (ExtractionPluginDataReader)ArgChecks.argNotNull((String)"reader", (Object)reader);
    }

    public Optional<Any> execute(Any message) throws ExecutionException, InterruptedException, IOException {
        try {
            return this.executeUnsafe(message);
        }
        catch (Throwable t) {
            this.shutdownTransferStates();
            throw t;
        }
    }

    private Optional<Any> executeUnsafe(Any message) throws ExecutionException, InterruptedException, IOException {
        if (message.is(RpcBeginDataStream.class)) {
            RpcBeginDataStream rpcBeginData = (RpcBeginDataStream)Unpack.any((Any)message, RpcBeginDataStream.class);
            ExtractionPluginGrpcAdapter.assertEqualId(rpcBeginData.getTraceId(), this._traceStack.peek().id());
            this.currentTransfer().start(rpcBeginData.getDataType());
            return Optional.empty();
        }
        if (message.is(RpcWriteDataStream.class)) {
            RpcWriteDataStream rpcWriteData = (RpcWriteDataStream)Unpack.any((Any)message, RpcWriteDataStream.class);
            ExtractionPluginGrpcAdapter.assertEqualId(rpcWriteData.getTraceId(), this._traceStack.peek().id());
            this.currentTransfer().write(rpcWriteData.getDataType(), rpcWriteData.getData().toByteArray());
            return Optional.empty();
        }
        if (message.is(RpcFinishDataStream.class)) {
            RpcFinishDataStream rpcFinishData = (RpcFinishDataStream)Unpack.any((Any)message, RpcFinishDataStream.class);
            ExtractionPluginGrpcAdapter.assertEqualId(rpcFinishData.getTraceId(), this._traceStack.peek().id());
            this.currentTransfer().finish(rpcFinishData.getDataType());
            return Optional.empty();
        }
        if (message.is(RpcRead.class)) {
            RpcRead read = (RpcRead)Unpack.any((Any)message, RpcRead.class);
            return Optional.of(Any.pack(Pack.primitive((Object)this.executeRead(read))));
        }
        if (message.is(RpcSearchRequest.class)) {
            RpcSearchRequest searchRequest = message.unpack(RpcSearchRequest.class);
            int count = searchRequest.getCount();
            String query = searchRequest.getQuery();
            SearchResult result = this._searcher.search(query, count);
            result.getTraces().forEach(this._reader::markDataAvailable);
            return Optional.of(Any.pack(Pack.searchResult((SearchResult)result)));
        }
        if (message.is(RpcEnrichTrace.class)) {
            RpcTrace rpcTrace = ((RpcEnrichTrace)Unpack.any((Any)message, RpcEnrichTrace.class)).getTrace();
            TraceState trace = this._traceStack.peek();
            ExtractionPluginGrpcAdapter.assertEqualId(rpcTrace.getId(), trace.id());
            ExtractionPluginGrpcAdapter.enrichTraceWith(trace.trace(), rpcTrace);
            return Optional.empty();
        }
        if (message.is(RpcBeginChild.class)) {
            RpcBeginChild rpcBeginTrace = message.unpack(RpcBeginChild.class);
            TraceState parent = this._traceStack.peek();
            ClientTrace child = parent.newChild(rpcBeginTrace.getName());
            String childId = rpcBeginTrace.getId();
            this.assertIsDirectParentIdOf(parent.id(), childId);
            this._traceStack.push(this.childState(childId, child));
            return Optional.empty();
        }
        if (message.is(RpcFinishChild.class)) {
            String id = ((RpcFinishChild)Unpack.any((Any)message, RpcFinishChild.class)).getId();
            TraceState trace = this._traceStack.pop();
            ExtractionPluginGrpcAdapter.assertEqualId(id, trace.id());
            ClientTrace child = trace.trace();
            try {
                child.save();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to store child: " + child.name());
            }
            return Optional.empty();
        }
        if (message.is(RpcBatchUpdate.class)) {
            for (Any any : ((RpcBatchUpdate)Unpack.any((Any)message, RpcBatchUpdate.class)).getActionsList()) {
                this.execute(any);
            }
            return Optional.of(Any.pack(RpcNull.getDefaultInstance()));
        }
        if (message.is(RpcFinish.class)) {
            for (Any any : ((RpcFinish)Unpack.any((Any)message, RpcFinish.class)).getUpdate().getActionsList()) {
                this.execute(any);
            }
            if (this._traceStack.size() != 1) {
                throw new IllegalStateException("not all children have been finished");
            }
            return Optional.empty();
        }
        if (message.is(RpcPartialFinishWithError.class)) {
            for (Any any : ((RpcPartialFinishWithError)Unpack.any((Any)message, RpcPartialFinishWithError.class)).getActionsList()) {
                this.executePartial(any);
            }
            if (this._traceStack.size() != 1) {
                throw new IllegalStateException("not all children have been finished");
            }
            this.currentTransfer().shutdownAndAwait();
            return Optional.empty();
        }
        throw new IllegalStateException("unsupported type of message: " + message);
    }

    private Optional<Any> executePartial(Any message) throws ExecutionException, InterruptedException, IOException {
        String id;
        if (message.is(RpcEnrichTrace.class)) {
            id = ((RpcEnrichTrace)Unpack.any((Any)message, RpcEnrichTrace.class)).getTrace().getId();
            while (!this._traceStack.isEmpty() && !this._traceStack.peek().id().equals(id)) {
                this._traceStack.pop().transfer().shutdownAndAwait();
            }
        }
        if (message.is(RpcFinishChild.class)) {
            id = ((RpcFinishChild)Unpack.any((Any)message, RpcFinishChild.class)).getId();
            while (!this._traceStack.isEmpty() && !this._traceStack.peek().id().equals(id)) {
                this._traceStack.pop().transfer().shutdownAndAwait();
            }
        }
        if (message.is(RpcBeginChild.class)) {
            id = ((RpcBeginChild)Unpack.any((Any)message, RpcBeginChild.class)).getId();
            while (!this._traceStack.isEmpty() && !ExtractionPluginGrpcAdapter.isDirectParentIdOf(this._traceStack.peek().id(), id)) {
                this._traceStack.pop().transfer().shutdownAndAwait();
            }
        }
        return this.execute(message);
    }

    private StreamTransferState currentTransfer() {
        return this._traceStack.peek().transfer();
    }

    private static void assertEqualId(String actual, String expected) {
        if (!actual.equals(expected)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "id is expected to be %s, but instead is %s", expected, actual));
        }
    }

    private void assertIsDirectParentIdOf(String parentId, String childId) {
        if (!ExtractionPluginGrpcAdapter.isDirectParentIdOf(parentId, childId)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "id %s is expected to be a direct child of %s, but it is not", childId, parentId));
        }
    }

    private static boolean isDirectParentIdOf(String parentId, String childId) {
        return childId.startsWith(parentId) && parentId.length() == childId.lastIndexOf("-");
    }

    private static void enrichTraceWith(Trace child, RpcTrace rpcChild) {
        rpcChild.getTransformationsList().forEach(rpcTransformation -> child.setData(rpcTransformation.getDataType(), Unpack.transformations(rpcTransformation.getTransformationsList())));
        rpcChild.getTypesList().forEach(arg_0 -> ((Trace)child).addType(arg_0));
        rpcChild.getPropertiesList().forEach(property -> child.set(property.getName(), Unpack.primitive((Any)property.getValue())));
        rpcChild.getTraceletsList().forEach(rpcTracelet -> child.addTracelet(Unpack.tracelet((RpcTracelet)rpcTracelet)));
    }

    private byte[] executeRead(RpcRead read) throws IOException {
        String traceUid = this.unpackTraceUid(read);
        return this._reader.read(traceUid, read.getDataType(), read.getPosition(), read.getCount());
    }

    private String unpackTraceUid(RpcRead read) {
        if (!read.getTraceId().isEmpty()) {
            if (read.getTraceId().equals(CURRENT_PROCESS_TRACE_MARKER)) {
                return read.getTraceId();
            }
            throw new IllegalStateException("The sdk used to create your plugin is outdated. This version still uses the traceId field instead of traceUid to identify trace data. Update to at least 0.4.9.");
        }
        return read.getTraceUid();
    }

    private void shutdownTransferStates() {
        try {
            for (TraceState state : this._traceStack) {
                try {
                    state.transfer().shutdownAndAwait();
                }
                catch (Exception e) {
                    LOG.error("error while trying to shut down transfer for Trace with id {}", (Object)state.id(), (Object)e);
                }
            }
            this._executor.shutdownNow();
            this._executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    public void error(Throwable error) {
        this.error(error, "Error occurred during processing of the trace");
    }

    public void error(Throwable error, String logMessage) {
        LOG.debug(logMessage, error);
        this._error = error;
    }

    public Optional<Throwable> error() {
        return Optional.ofNullable(this._error);
    }

    private TraceState rootState(ClientTrace root) {
        return new TraceState(CURRENT_PROCESS_TRACE_MARKER, root);
    }

    private TraceState childState(String id, ClientTrace child) {
        return new TraceState(id, child);
    }

    final class TraceState {
        private final String _id;
        private final ClientTrace _trace;
        private final StreamTransferState _transfer;

        TraceState(String id, ClientTrace trace) {
            this._id = (String)ArgChecks.argNotNull((String)"id", (Object)id);
            this._trace = (ClientTrace)ArgChecks.argNotNull((String)"trace", (Object)trace);
            this._transfer = StreamTransferState.create(trace, ExtractionPluginGrpcAdapter.this._executor);
        }

        String id() {
            return this._id;
        }

        ClientTrace trace() {
            return this._trace;
        }

        StreamTransferState transfer() {
            return this._transfer;
        }

        ClientTrace newChild(String name) {
            return this._trace.newChild(name);
        }
    }
}

