/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.util.ArgChecks;

final class StreamTransferState {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final long TASK_FINISH_WAIT_MS = TimeUnit.SECONDS.toMillis(16L);
    private final Trace _trace;
    private final ExecutorService _executor;
    private final AtomicBoolean _inTransfer;
    private String _dataType;
    private OutputStream _stream;
    private Future<?> _task;

    private StreamTransferState(Trace trace, ExecutorService executor) {
        this._trace = (Trace)ArgChecks.argNotNull((String)"trace", (Object)trace);
        this._executor = (ExecutorService)ArgChecks.argNotNull((String)"executor", (Object)executor);
        this._inTransfer = new AtomicBoolean();
    }

    static StreamTransferState create(Trace trace, ExecutorService executor) {
        return new StreamTransferState(trace, executor);
    }

    private void setup(String dataType) throws IOException {
        PipedInputStream input = new PipedInputStream(32768);
        this._dataType = dataType;
        this._stream = new PipedOutputStream(input);
        this._task = this._executor.submit(() -> {
            try (PipedInputStream pipedInputStream = input;){
                this._trace.setData(dataType, (InputStream)input);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    StreamTransferState start(String dataType) throws IOException {
        this.flagStart();
        this.setup(dataType);
        return this;
    }

    StreamTransferState write(String dataType, byte[] data) throws IOException {
        this.assertInitialized(dataType);
        this._stream.write(data);
        return this;
    }

    StreamTransferState finish(String dataType) throws IOException {
        this.assertInitialized(dataType);
        this.shutdownAndAwait();
        return this;
    }

    void shutdownAndAwait() throws IOException {
        if (!this._inTransfer.get()) {
            return;
        }
        try {
            this._stream.flush();
            this._stream.close();
            this._task.get(TASK_FINISH_WAIT_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.cleanup();
            this.flagFinish();
        }
    }

    private void cleanup() {
        this._task = null;
        this._stream = null;
        this._dataType = null;
    }

    private void flagStart() {
        if (this._inTransfer.getAndSet(true)) {
            throw new IllegalStateException("already writing stream of type: " + this._dataType);
        }
    }

    private void flagFinish() {
        this._inTransfer.set(false);
    }

    private void assertInitialized(String dataType) {
        if (!this._inTransfer.get()) {
            throw new IllegalStateException("currently not in transfer mode");
        }
        if (!dataType.equals(this._dataType)) {
            throw new IllegalStateException(String.format(Locale.ROOT, "currently writing stream of type '%s' instead of '%s'", this._dataType, dataType));
        }
    }
}

