/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Collection;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.RegexCache;

final class HqlMatcherUtil {
    private static final RegexCache REGEX_CACHE = new RegexCache();

    private HqlMatcherUtil() {
    }

    static boolean matchStringValuesWithWildcards(boolean fullMatch, String matcherValue, String traceValue) {
        if (traceValue == null) {
            return false;
        }
        if (!fullMatch && HqlMatcherUtil.hasWildcards(matcherValue)) {
            String regexValue = HqlMatcherUtil.wildcardToRegex(matcherValue);
            return REGEX_CACHE.compileRegex("^" + regexValue + "$").test(traceValue);
        }
        return traceValue.equals(matcherValue);
    }

    static boolean matchStringValuesWithWildcards(boolean fullMatch, String matcherValue, Collection<String> traceValues) {
        if (matcherValue == null) {
            return false;
        }
        for (String traceValue : traceValues) {
            if (!HqlMatcherUtil.matchStringValuesWithWildcards(fullMatch, matcherValue, traceValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasWildcards(String str) {
        return str.contains("?") || str.contains("*");
    }

    private static String wildcardToRegex(String str) {
        return str.replace("?", ".").replace("*", ".*");
    }
}

