/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.handler.codec.serialization;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.buffer.ByteBuf;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.buffer.ByteBufOutputStream;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.channel.ChannelHandlerContext;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.handler.codec.MessageToByteEncoder;
import org.hansken.ep.shade.io.grpc.netty.shaded.org.hansken.ep.shade.io.netty.util.internal.ObjectUtil;

public class CompatibleObjectEncoder
extends MessageToByteEncoder<Serializable> {
    private final int resetInterval;
    private int writtenObjects;

    public CompatibleObjectEncoder() {
        this(16);
    }

    public CompatibleObjectEncoder(int resetInterval) {
        this.resetInterval = ObjectUtil.checkPositiveOrZero(resetInterval, "resetInterval");
    }

    protected ObjectOutputStream newObjectOutputStream(OutputStream out) throws Exception {
        return new ObjectOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, Serializable msg, ByteBuf out) throws Exception {
        ObjectOutputStream oos = this.newObjectOutputStream(new ByteBufOutputStream(out));
        try {
            if (this.resetInterval != 0) {
                ++this.writtenObjects;
                if (this.writtenObjects % this.resetInterval == 0) {
                    oos.reset();
                }
            }
            oos.writeObject(msg);
            oos.flush();
        }
        finally {
            oos.close();
        }
    }
}

