/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

import org.hansken.plugin.extraction.api.DataContext;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.api.PluginType;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcher;

public final class Checks {
    private Checks() {
    }

    public static boolean isMetaContext(DataContext context) {
        return "meta".equals(context.dataType());
    }

    public static void assertIsNotMeta(String dataType) {
        if ("meta".equals(dataType)) {
            throw new IllegalStateException("meta context has no associated data stream");
        }
    }

    public static boolean matches(PluginType type, HqlMatcher matcher, Trace trace, String dataType) {
        if ("meta".equals(dataType)) {
            return type == PluginType.META_EXTRACTION_PLUGIN && matcher.match((ImmutableTrace)trace, dataType);
        }
        return (type == PluginType.EXTRACTION_PLUGIN || type == PluginType.DEFERRED_EXTRACTION_PLUGIN) && matcher.match((ImmutableTrace)trace, dataType);
    }
}

