/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import nl.minvenj.nfi.flits.api.result.ThrowableResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;

final class PluginThrowableResult {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final String _class;
    private final String _message;
    private final String _messageStartsWith;
    private final String[] _messageContainsInOrder;

    private PluginThrowableResult(@JsonProperty(value="class") String aClass, @JsonProperty(value="message") String message, @JsonProperty(value="message.startsWith") String messageStartsWith, @JsonProperty(value="message.containsInOrder") String[] messageContainsInOrder) {
        this._class = aClass;
        this._message = message;
        this._messageStartsWith = messageStartsWith;
        this._messageContainsInOrder = messageContainsInOrder;
    }

    private boolean isValidUsingCustomMatching(ThrowableResult result) {
        String resultClassName = result.throwable().getClass().getName();
        String resultMessage = result.throwable().getMessage();
        Assertions.assertEquals((Object)resultClassName, (Object)this._class);
        if (this._messageStartsWith != null) {
            MatcherAssert.assertThat((Object)resultMessage, (Matcher)Matchers.startsWith((String)this._messageStartsWith));
        }
        if (this._messageContainsInOrder != null) {
            MatcherAssert.assertThat((Object)resultMessage, (Matcher)Matchers.stringContainsInOrder((String[])this._messageContainsInOrder));
        }
        return this._message == null;
    }

    static boolean isValidUsingCustomMatching(ThrowableResult result, Path inputPath) throws IOException {
        Assertions.assertTrue((boolean)Files.isRegularFile(inputPath, new LinkOption[0]), (String)("No result file found, expected to be located at: " + inputPath));
        String expectedJson = Files.readString(inputPath);
        PluginThrowableResult pluginThrowableResult = (PluginThrowableResult)OBJECT_MAPPER.readValue(expectedJson, PluginThrowableResult.class);
        return pluginThrowableResult.isValidUsingCustomMatching(result);
    }
}

