/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.apache.commons.lang3.text.translate.UnicodeUnescaper;
import org.hansken.plugin.extraction.util.ArgChecks;

public final class HqlHumanUtil {
    private static final String GLUE_CHARS = "@.,-_";
    private static final String NO_ESCAPE = "#";
    private static final String[][] LOOKUPS = new String[][]{{"'", "\\'"}, {"\\", "\\\\"}, {"\b", "\\b"}, {"\f", "\\f"}, {"\n", "\\n"}, {"\r", "\\r"}, {"\t", "\\t"}};
    private static final CharSequenceTranslator ESCAPE = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])LOOKUPS), new LookupTranslator((CharSequence[][])new String[][]{{"*", "\\*"}, {"?", "\\?"}}), JavaUnicodeEscaper.below((int)32), JavaUnicodeEscaper.between((int)127, (int)191), JavaUnicodeEscaper.above((int)55296)});
    private static final CharSequenceTranslator ESCAPE_TERM = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])LOOKUPS), new LookupTranslator((CharSequence[][])new String[][]{{"*", "\\*"}, {"?", "\\?"}, {":", "\\:"}}), JavaUnicodeEscaper.below((int)32), JavaUnicodeEscaper.between((int)127, (int)191), JavaUnicodeEscaper.above((int)55296), new TermEscaper()});
    private static final CharSequenceTranslator UNESCAPE = new AggregateTranslator(new CharSequenceTranslator[]{new UnicodeCodepointUnescaper(), new UnicodeUnescaper(), new LookupTranslator((CharSequence[][])EntityArrays.invert((String[][])LOOKUPS)), new LookupTranslator((CharSequence[][])new String[][]{{"\\", ""}})});
    private static final CharSequenceTranslator UNESCAPE_KEEP_WILDCARDS = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])new String[][]{{"\\*", "\\*"}, {"\\?", "\\?"}, {"\\\\", "\\\\"}}), UNESCAPE});

    private HqlHumanUtil() {
    }

    public static String escapeText(String text) {
        ArgChecks.argNotNull((String)"text", (Object)text);
        return ESCAPE.translate((CharSequence)text);
    }

    public static String escapeTerm(String text) {
        ArgChecks.argNotNull((String)"text", (Object)text);
        String escaped = ESCAPE_TERM.translate((CharSequence)text);
        boolean escapeFirst = text.length() > 0 && GLUE_CHARS.indexOf(text.charAt(0)) >= 0 && escaped.charAt(0) != '\\';
        return escapeFirst ? "\\" + escaped : escaped;
    }

    public static String unescape(String text) {
        ArgChecks.argNotNull((String)"text", (Object)text);
        return UNESCAPE.translate((CharSequence)text);
    }

    public static String unescapeKeepWildcards(String text) {
        ArgChecks.argNotNull((String)"text", (Object)text);
        return UNESCAPE_KEEP_WILDCARDS.translate((CharSequence)text);
    }

    public static boolean isPlain(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i > 0 && i < text.length() - 1 && GLUE_CHARS.indexOf(c) >= 0 || c == '#' || Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static class TermEscaper
    extends CharSequenceTranslator {
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            char c = input.charAt(index);
            if (!Character.isLetterOrDigit(c) && HqlHumanUtil.GLUE_CHARS.indexOf(c) < 0 && HqlHumanUtil.NO_ESCAPE.indexOf(c) < 0) {
                out.write(92);
            }
            out.write(c);
            return 1;
        }
    }

    public static class UnicodeCodepointUnescaper
    extends CharSequenceTranslator {
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            int pos = index;
            int length = input.length();
            if (pos + 2 >= length || input.charAt(pos) != '\\' || input.charAt(pos + 1) != 'u') {
                return 0;
            }
            if ((pos += 2) < input.length() && input.charAt(pos) == '{') {
                int start = ++pos;
                while (pos < length && UnicodeCodepointUnescaper.isHex(input.charAt(pos))) {
                    ++pos;
                }
                int end = pos;
                if (pos < length && input.charAt(pos) == '}') {
                    ++pos;
                    if (end > start) {
                        CharSequence unicode = input.subSequence(start, end);
                        try {
                            int codePoint = Integer.parseInt(unicode.toString(), 16);
                            UnicodeCodepointUnescaper.writeCodePoint(out, codePoint);
                            return pos - index;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                throw new IllegalArgumentException("bad unicode codepoint escape sequence: " + input.subSequence(index, pos));
            }
            return 0;
        }

        private static boolean isHex(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        private static void writeCodePoint(Writer writer, int codePoint) throws IOException {
            if (!Character.isDefined(codePoint)) {
                throw new IllegalArgumentException("undefined unicode codepoint: \\u{" + Integer.toHexString(codePoint) + "}");
            }
            if (Character.isBmpCodePoint(codePoint)) {
                writer.write((char)codePoint);
            } else {
                writer.write(Character.highSurrogate(codePoint));
                writer.write(Character.lowSurrogate(codePoint));
            }
        }
    }
}

