/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.api;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsProcessor;
import nl.minvenj.nfi.flits.api.FlitsResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.io.FileMatchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicNode;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;

public abstract class Flits {
    public static final String RESULT_FILE_SUFFIX = ".json";
    public static final String INFO_FILE_INFIX = ".flits.info";
    static final String ORPHANED_RESULT_FILES_DIRECTORY = "orphanedResultFiles";

    public abstract Path testPath();

    public abstract Path resultPath();

    public abstract FlitsProcessor processor();

    public boolean regenerate() {
        return this.getSystemVariable().orElse(false);
    }

    public String pattern() {
        return "glob:**";
    }

    public String resultFileSuffix() {
        return "." + this.processor().name() + RESULT_FILE_SUFFIX;
    }

    @TestFactory
    List<DynamicNode> tests() {
        ArgChecks.argNotNull("testPath", this.testPath());
        ArgChecks.argNotNull("resultPath", this.resultPath());
        ArgChecks.argNotNull("processor", this.processor());
        ArgChecks.argNotNull("pattern", this.pattern());
        Flits.checkPath(this.testPath(), "test");
        if (!this.regenerateTestResults()) {
            Flits.checkPath(this.resultPath(), "result");
        }
        BiConsumer<FlitsResult, Path> resultProcessor = this.regenerateTestResults() ? this::write : this::compare;
        List<DynamicNode> tests = this.toDynamicNodes(this.testPath(), resultProcessor);
        if (tests.isEmpty()) {
            throw new IllegalArgumentException("No testfile found. Did you specify the correct directory or filter?");
        }
        return tests;
    }

    @Test
    public void detectOrphanedResultFiles() {
        try (Stream<Path> files = Files.walk(this.resultPath(), new FileVisitOption[0]);){
            Collection orphanedResultFiles = files.filter(resultPath -> !Files.isDirectory(resultPath, new LinkOption[0])).filter(this::isOrphanedResultFile).collect(Collectors.toList());
            if (this.regenerateTestResults() && !orphanedResultFiles.isEmpty()) {
                this.moveOrphanedResultFiles(orphanedResultFiles);
                System.out.println(orphanedResultFiles.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.joining("\n", "The following orphaned result files were moved to this directory:\n" + this.getOrphanedResultFilesPath() + "/\n\n", "\n\nPlease verify if the above mentioned files can be deleted and remove the directory.")));
            } else {
                String reason = orphanedResultFiles.stream().map(Path::toString).collect(Collectors.joining("\n", "There are orphaned result files present. The following file(s) should be checked:\n", ""));
                MatcherAssert.assertThat((String)reason, (boolean)orphanedResultFiles.isEmpty());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Test
    public void orphanedResultFilesDirectoryShouldNotBePresent() {
        MatcherAssert.assertThat((String)("There should not be an orphaned result files directory present at this location:\n" + this.getOrphanedResultFilesPath()), (boolean)Files.notExists(this.getOrphanedResultFilesPath(), new LinkOption[0]));
    }

    @Test
    public void regenerateShouldBeOff() {
        Assertions.assertFalse((boolean)this.regenerateTestResults(), (String)"It is not allowed to (over)write results in production code.");
    }

    public Path getOrphanedResultFilesPath() {
        return this.resultPath().getParent().resolve(ORPHANED_RESULT_FILES_DIRECTORY);
    }

    public final boolean regenerateTestResults() {
        return this.getSystemVariable().orElse(this.regenerate());
    }

    private Optional<Boolean> getSystemVariable() {
        return Optional.ofNullable(System.getProperty("flits.regenerate")).map(regenerate -> !regenerate.equalsIgnoreCase("false"));
    }

    boolean isOrphanedResultFile(Path resultFilePath) {
        return resultFilePath.getFileName().toString().endsWith(RESULT_FILE_SUFFIX) && !Files.exists(this.expectedTestFilePath(resultFilePath), new LinkOption[0]);
    }

    private Path expectedTestFilePath(Path resultFilePath) {
        Path relativePath;
        Path resultFileName = resultFilePath.getFileName();
        String testFilename = resultFileName.toString();
        if (testFilename.contains(".")) {
            String[] resultFilenameParts = testFilename.split("\\.");
            CharSequence[] resultFilenameWithoutJsonExtension = Arrays.copyOf(resultFilenameParts, resultFilenameParts.length - 2);
            testFilename = String.join((CharSequence)".", resultFilenameWithoutJsonExtension);
        }
        if ((relativePath = this.resultPath().relativize(resultFilePath).getParent()) == null) {
            return this.testPath().resolve(testFilename);
        }
        return this.testPath().resolve(relativePath).resolve(testFilename);
    }

    private void moveOrphanedResultFiles(Collection<Path> orphanedResultFiles) throws IOException {
        Path newOrphanedResultFilesDirectory = Files.createDirectories(this.getOrphanedResultFilesPath(), new FileAttribute[0]);
        for (Path path : orphanedResultFiles) {
            Files.move(path, newOrphanedResultFilesDirectory.resolve(path.getFileName()), new CopyOption[0]);
        }
    }

    private List<DynamicNode> toDynamicNodes(Path directory, BiConsumer<FlitsResult, Path> resultProcessor) {
        Predicate<Path> pathFilter = this.getPathFilter(this.pattern());
        try (Stream paths = Flits.walk(directory, path -> Files.isDirectory(path, new LinkOption[0]) ? this.getFolderContainer((Path)path, resultProcessor) : this.getFileContainer((Path)path, resultProcessor, pathFilter).stream());){
            List<DynamicNode> list = paths.collect(Collectors.toList());
            return list;
        }
    }

    public static <T> T walkTestFiles(Path baseFolder, Function<Stream<Path>, T> testFilesHandler) {
        try (Stream<Path> fileStream = Flits.walkRecursive(baseFolder);){
            T t = testFilesHandler.apply(fileStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])));
            return t;
        }
    }

    private static Stream<Path> walkRecursive(Path baseFolder) {
        return Flits.walk(baseFolder, path -> Files.isDirectory(path, new LinkOption[0]) ? Flits.walkRecursive(path) : Stream.of(path));
    }

    private static <T> Stream<T> walk(Path baseFolder, Function<Path, Stream<T>> processor) {
        try {
            return Flits.walkDirectory(baseFolder).filter(path -> !baseFolder.equals(path)).filter(path -> !Flits.isFlitsInfoFile(path)).flatMap(processor).filter(Objects::nonNull);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static Stream<Path> walkDirectory(Path directory) throws IOException {
        return Files.walk(directory, 1, new FileVisitOption[0]);
    }

    private Optional<DynamicNode> getFileContainer(Path path, BiConsumer<FlitsResult, Path> libraryResultProcessor, Predicate<Path> pathFilter) {
        if (pathFilter.test(path)) {
            String testName = this.getUniqueTestName(path);
            return Optional.of(DynamicTest.dynamicTest((String)testName, () -> this.processTestFile(path, libraryResultProcessor)));
        }
        return Optional.empty();
    }

    private String getUniqueTestName(Path path) {
        String testName = path.getFileName().toString();
        Path parent = path.getParent();
        return parent == null ? testName : testName + " (" + this.testPath().relativize(parent) + "/)";
    }

    private Stream<DynamicNode> getFolderContainer(Path path, BiConsumer<FlitsResult, Path> libraryResultProcessor) {
        List<DynamicNode> dynamicNodes = this.toDynamicNodes(path, libraryResultProcessor);
        if (!dynamicNodes.isEmpty()) {
            String testName = path.getFileName().toString();
            return Stream.of(DynamicContainer.dynamicContainer((String)testName, dynamicNodes));
        }
        return Stream.empty();
    }

    private Predicate<Path> getPathFilter(String pattern) {
        PathMatcher pathMatcher = this.testPath().getFileSystem().getPathMatcher(pattern);
        return path -> pathMatcher.matches(this.testPath().relativize((Path)path));
    }

    static boolean isFlitsInfoFile(Path path) {
        return path.toString().contains(INFO_FILE_INFIX);
    }

    private static void checkPath(Path path, String typeOfPath) {
        String root = "Root ";
        if (path.toString().isEmpty()) {
            throw new IllegalArgumentException("Root " + typeOfPath + " path should not be empty.");
        }
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Root " + typeOfPath + " path should refer to an existing path, got: " + path);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Root " + typeOfPath + " path should be a directory, got: " + path);
        }
    }

    private void processTestFile(Path testFilePath, BiConsumer<FlitsResult, Path> libraryResultProcessor) {
        Path relativeTestFilePath = this.testPath().relativize(testFilePath);
        Path resultFilePath = this.resultPath().resolve(relativeTestFilePath + this.resultFileSuffix());
        try {
            this.processor().process(testFilePath, relativeTestFilePath, libraryResult -> libraryResultProcessor.accept((FlitsResult)libraryResult, resultFilePath), () -> MatcherAssert.assertThat((String)"Result should not exist, because the library did not process the test file.", (Object)resultFilePath.toFile(), (Matcher)Matchers.not((Matcher)FileMatchers.anExistingFile())));
        }
        catch (IOException e) {
            throw new UncheckedIOException("error loading test file: " + testFilePath, e);
        }
    }

    private void compare(FlitsResult actual, Path resultFilePath) {
        try {
            actual.validate(this.processor().validator(), resultFilePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void write(FlitsResult actual, Path resultFilePath) {
        try {
            actual.generate(this.processor().generator(), resultFilePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

