package org.hansken.plugin.extraction.main;

import static org.hansken.plugin.extraction.util.ArgChecks.argNotEmpty;
import static org.hansken.plugin.extraction.util.ArgChecks.argNotNull;

import java.nio.file.Path;

import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginClient;
import org.hansken.plugin.extraction.test.RemoteExtractionPluginFlits;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

import nl.minvenj.nfi.flits.api.Flits;

public final class StandaloneFlitsTest extends RemoteExtractionPluginFlits {
    private static Path _testPath;
    private static Path _resultPath;
    private static boolean _regenerate;
    private static String _host;
    private static int _port;
    private static String _pattern;
    private static ExtractionPluginClient _client;

    /**
     * Create a {@link Flits} test instance for remote extraction plugins.
     * See the linked FLITS class for documentation about the workings
     * and parameters.
     *
     * @param testPath the path containing the test inputs
     * @param resultPath the path containing the expected results
     * @param regenerate if one should regenerate the results
     * @param host the host on which the plugin server is running
     * @param port the port on which the plugin is served
     * @param pattern a file filter pattern
     */
    static void setup(final Path testPath, final Path resultPath, final boolean regenerate, final String host, final int port, final String pattern) {
        _testPath = argNotNull("testPath", testPath);
        _resultPath = argNotNull("resultPath", resultPath);
        _regenerate = regenerate;
        _host = argNotEmpty("host", host);
        _port = port;
        _pattern = pattern;
    }

    @BeforeAll
    static void init() throws Exception {
        _client = new ExtractionPluginClient(_host, _port);
    }

    @AfterAll
    static void destruct() throws InterruptedException {
        if (_client != null) {
            _client.close();
        }
    }

    @Override
    public String pattern() {
        return _pattern != null ? _pattern : super.pattern();
    }

    @Override
    public Path testPath() {
        return _testPath;
    }

    @Override
    public Path resultPath() {
        return _resultPath;
    }

    @Override
    protected ExtractionPluginClient pluginToTest() {
        return _client;
    }

    @Override
    public boolean regenerate() {
        return _regenerate;
    }
}