/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.base;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import nl.minvenj.nfi.flits.api.Trace;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.DefaultResultGenerator;
import nl.minvenj.nfi.flits.serialize.TraceToJson;
import org.hansken.plugin.extraction.test.base.ProcessingUtil;

public class DefaultPluginResultGenerator
extends DefaultResultGenerator {
    public DefaultPluginResultGenerator(TraceToJson traceToJson) {
        super(traceToJson);
    }

    @Override
    public void generate(TraceResult result, Path outputPath) throws IOException {
        super.generate(result, outputPath);
        this.writeDataStreams(outputPath, result.traces());
    }

    private void writeDataStreams(Path outputPath, List<Trace> traces) throws IOException {
        for (Trace trace : traces) {
            for (String dataType : ProcessingUtil.dataTypes(trace)) {
                Path dataFile = ProcessingUtil.createDataStreamPath(outputPath, (String)trace.get("id"), dataType);
                if (!Files.exists(dataFile, new LinkOption[0])) {
                    Files.createDirectories(dataFile.getParent(), new FileAttribute[0]);
                }
                Files.write(dataFile, ProcessingUtil.dataStream(trace, dataType), new OpenOption[0]);
            }
            this.writeDataStreams(outputPath, trace.children().collect(Collectors.toList()));
        }
    }
}

