/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.serialize;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.hansken.plugin.extraction.api.DataWriter;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.test.serialize.Deserialize;
import org.hansken.plugin.extraction.util.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestTrace
implements ClientTrace {
    private static final Logger LOG = LoggerFactory.getLogger(TestTrace.class);
    private final AtomicInteger _nextChildId = new AtomicInteger(0);
    private final AtomicInteger _nextTraceletId = new AtomicInteger(0);
    private final Set<String> _types;
    private final Map<String, Object> _properties;

    public TestTrace(String name) {
        this("0", name, "/" + name);
    }

    public TestTrace(String id, String name, String path) {
        this._types = new HashSet<String>();
        this._properties = new HashMap<String, Object>();
        this.set("id", id).set("name", (Object)name).set("path", (Object)path);
    }

    public TestTrace(String id, String name, String path, Set<String> types, Map<String, Object> properties) {
        this._types = types;
        this._properties = properties;
        this._properties.put("id", id);
        this._properties.put("name", name);
        this._properties.put("path", path);
    }

    public String traceId() {
        return "0";
    }

    public Set<String> types() {
        return this._types;
    }

    public Trace addType(String type) {
        this._types.add(type);
        return this;
    }

    public Set<String> properties() {
        return this._properties.keySet();
    }

    public <T> T get(String name) {
        return (T)this._properties.get(name);
    }

    public Trace set(String name, Object value) {
        if (name.startsWith("$")) {
            throw new IllegalArgumentException("cannot set a property name prefixed with $");
        }
        if (name.startsWith("#")) {
            throw new IllegalArgumentException("cannot set a property name prefixed with #");
        }
        this.changeProperty(name, value);
        return this;
    }

    public Trace addTracelet(Trace.Tracelet tracelet) {
        int traceletId = this._nextTraceletId.incrementAndGet();
        String propertyName = tracelet.getName();
        this.addType(propertyName);
        tracelet.getValue().forEach(traceletProperty -> this.changeProperty(propertyName + "." + traceletId + "." + traceletProperty.getName(), traceletProperty.getValue()));
        return this;
    }

    public Trace setData(String dataType, DataWriter writer) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        writer.writeTo((OutputStream)output);
        this.changeProperty("$" + dataType, output.toByteArray());
        return this;
    }

    public Trace setData(String dataType, List<DataTransformation> transformations) {
        try {
            String serializedTransformations = Deserialize.OBJECT_MAPPER.writeValueAsString(transformations);
            this.changeProperty("#" + dataType + ".descriptor", serializedTransformations);
        }
        catch (JsonProcessingException e) {
            LOG.error("Could not serialize transformation.", (Throwable)e);
        }
        return this;
    }

    public Trace newChild(String name, ThrowingConsumer<Trace, IOException> enrichChildCallback) throws IOException {
        enrichChildCallback.accept((Object)new TestTrace(this.get("id") + "-" + this._nextChildId.getAndIncrement(), name, this.get("path") + "/" + name));
        return this;
    }

    public String name() {
        return (String)this.get("name");
    }

    public TestTrace newChild(String name) {
        return new TestTrace(this.get("id") + "-" + this._nextChildId.getAndIncrement(), name, this.get("path") + "/" + name);
    }

    public void save() throws Exception {
    }

    private void changeProperty(String propertyName, Object propertyValue) {
        Object valueOld = this._properties.get(propertyName);
        if (valueOld != null && !(valueOld instanceof Collection)) {
            throw new IllegalStateException("property " + propertyName + " already set");
        }
        this._properties.put(propertyName, propertyValue);
    }
}

