/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.base;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.stream.Collectors;
import nl.minvenj.nfi.flits.api.Trace;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.test.serialize.Deserialize;
import org.hansken.plugin.extraction.test.serialize.TestSearchTrace;

public final class ProcessingUtil {
    public static final String SEARCH_TRACES_DIR_NAME = "searchtraces";

    private ProcessingUtil() {
    }

    public static Set<String> dataTypes(Trace trace) {
        return trace.properties().stream().filter(property -> property.startsWith("$")).map(property -> property.substring("$".length())).collect(Collectors.toSet());
    }

    public static boolean hasDataStreamOfType(Trace trace, String dataType) {
        return ProcessingUtil.dataStream(trace, dataType) != null;
    }

    public static byte[] dataStream(Trace trace, String dataType) {
        return (byte[])trace.get("$" + dataType);
    }

    public static Path createDataStreamPath(Path rootTracePath, String tracePath, String dataType) {
        String fileName = rootTracePath.getFileName().toString();
        String fileNameWithoutType = fileName.substring(0, fileName.lastIndexOf(46));
        return rootTracePath.resolveSibling(fileNameWithoutType + "." + tracePath + "." + dataType);
    }

    public static String extractFileName(Path path) {
        String fileName = path.getFileName().toString();
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public static Path getSearchTracesPath(Path tracePath) {
        return Paths.get(String.valueOf(tracePath.getParent()), ProcessingUtil.extractFileName(tracePath), SEARCH_TRACES_DIR_NAME);
    }

    public static boolean isFileWithExtension(Path filePath, String extension) {
        String fileName = filePath.getFileName().toString();
        return ProcessingUtil.extractFileExtension(fileName).equals(extension);
    }

    public static String extractFileExtension(Path filePath) {
        return ProcessingUtil.extractFileExtension(filePath.getFileName().toString());
    }

    private static String extractFileExtension(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    public static SearchTrace searchTraceFromPath(Path tracePath) {
        try {
            return Files.exists(tracePath, new LinkOption[0]) ? Deserialize.searchTraceFromJson(tracePath) : new TestSearchTrace("test-input-trace");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

