/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.hansken.plugin.extraction.api.Author;
import org.hansken.plugin.extraction.api.BaseExtractionPlugin;
import org.hansken.plugin.extraction.api.DeferredExtractionPlugin;
import org.hansken.plugin.extraction.api.ExtractionPlugin;
import org.hansken.plugin.extraction.api.MaturityLevel;
import org.hansken.plugin.extraction.api.MetaExtractionPlugin;
import org.hansken.plugin.extraction.api.PluginId;
import org.hansken.plugin.extraction.api.PluginResources;
import org.hansken.plugin.extraction.api.PluginType;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PluginInfo.class);
    private final PluginType _type;
    @Deprecated
    private final String _name;
    private final String _pluginVersion;
    private final String _description;
    private final Author _author;
    private final MaturityLevel _maturityLevel;
    private final String _hqlMatcher;
    private final String _webpageUrl;
    private final int _deferredIterations;
    private final PluginId _id;
    private final String _license;
    private final PluginResources _resources;

    private PluginInfo(PluginType type, String name, String pluginVersion, String description, Author author, MaturityLevel maturityLevel, String hqlMatcher, String webpageUrl, int deferredIterations, PluginId id, String license, PluginResources resources) {
        if ((name == null || name.isEmpty()) && id == null) {
            throw new NullPointerException("argument 'id' cannot be null");
        }
        this._name = name;
        this._id = name == null ? ArgChecks.argNotNull("id", id) : id;
        this._license = name == null ? ArgChecks.argNotEmpty("license", license) : license;
        this._type = ArgChecks.argNotNull("type", type);
        this._pluginVersion = ArgChecks.argNotNull("pluginVersion", pluginVersion);
        this._description = ArgChecks.argNotNull("description", description);
        this._author = ArgChecks.argNotNull("author", author);
        this._maturityLevel = ArgChecks.argNotNull("maturityLevel", maturityLevel);
        this._hqlMatcher = ArgChecks.argNotNull("hqlMatcher", hqlMatcher);
        this._webpageUrl = ArgChecks.argNotNull("webpageUrl", webpageUrl);
        if (deferredIterations < 1 || deferredIterations > 20) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid value for deferredIterations: %s. Valid values are 1 <= 20.", deferredIterations));
        }
        this._deferredIterations = deferredIterations;
        this._resources = resources;
    }

    public static Builder builderFor(BaseExtractionPlugin plugin) {
        if (ArgChecks.argNotNull("plugin", plugin) instanceof MetaExtractionPlugin) {
            return PluginInfo.builderFor(PluginType.META_EXTRACTION_PLUGIN);
        }
        if (ArgChecks.argNotNull("plugin", plugin) instanceof DeferredExtractionPlugin) {
            return PluginInfo.builderFor(PluginType.DEFERRED_EXTRACTION_PLUGIN);
        }
        if (ArgChecks.argNotNull("plugin", plugin) instanceof ExtractionPlugin) {
            return PluginInfo.builderFor(PluginType.EXTRACTION_PLUGIN);
        }
        throw new RuntimeException("Unsupported type of plugin: " + plugin.getClass().getName());
    }

    public static Builder builderFor(PluginType type) {
        return new Builder(ArgChecks.argNotNull("type", type));
    }

    public PluginType pluginType() {
        return this._type;
    }

    @Deprecated
    public String name() {
        return this._name;
    }

    public String fullName() {
        if (this._id != null) {
            return this._id.toString();
        }
        if (!this._name.isBlank()) {
            LOG.warn("The full name of the plugin is based on the deprecated field 'name' because 'id' was not set. Make sure you use the latest version of the Extraction Plugins SDK and consider setting 'id'.");
            return this._name;
        }
        throw new IllegalArgumentException("PluginInfo has no fullName. Set the id.");
    }

    public String pluginVersion() {
        return this._pluginVersion;
    }

    public String description() {
        return this._description;
    }

    public Author author() {
        return this._author;
    }

    public MaturityLevel maturityLevel() {
        return this._maturityLevel;
    }

    public String hqlMatcher() {
        return this._hqlMatcher;
    }

    public String webpageUrl() {
        return this._webpageUrl;
    }

    public int deferredIterations() {
        return this._deferredIterations;
    }

    public PluginId id() {
        return this._id;
    }

    public String license() {
        return this._license;
    }

    public PluginResources resources() {
        return this._resources;
    }

    public static final class Builder {
        private static final int DEFERRED_ITERATIONS_DEFAULT = 1;
        private final PluginType _type;
        private String _name;
        private String _pluginVersion;
        private String _description;
        private Author _author;
        private MaturityLevel _maturityLevel;
        private String _hqlMatcher;
        private String _webpageUrl;
        private int _deferredIterations;
        private PluginId _id;
        private String _license;
        private PluginResources _resources;

        Builder(PluginType type) {
            this(type, "/extraction-plugin-build.properties");
        }

        Builder(PluginType type, String pluginInfoResourceName) {
            this._type = ArgChecks.argNotNull("type", type);
            this._deferredIterations = 1;
            if (pluginInfoResourceName != null) {
                this.loadFromProperties(pluginInfoResourceName);
            }
        }

        private void loadFromProperties(String pluginResourceName) {
            try (InputStream buildInfoStream = PluginInfo.class.getResourceAsStream(pluginResourceName);){
                if (buildInfoStream != null) {
                    Properties buildProperties = new Properties();
                    buildProperties.load(buildInfoStream);
                    if (buildProperties.containsKey("project.version")) {
                        this._pluginVersion = buildProperties.getProperty("project.version");
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Deprecated
        public Builder name(String name) {
            this._name = ArgChecks.argNotEmpty("name", name);
            return this;
        }

        public Builder pluginVersion(String version) {
            this._pluginVersion = ArgChecks.argNotEmpty("version", version);
            return this;
        }

        public Builder description(String description) {
            this._description = ArgChecks.argNotEmpty("description", description);
            return this;
        }

        public Builder author(Author author) {
            this._author = ArgChecks.argNotNull("author", author);
            return this;
        }

        public Builder maturityLevel(MaturityLevel maturityLevel) {
            this._maturityLevel = ArgChecks.argNotNull("maturityLevel", maturityLevel);
            return this;
        }

        public Builder hqlMatcher(String hqlMatcher) {
            this._hqlMatcher = ArgChecks.argNotNull("hqlMatcher", hqlMatcher);
            return this;
        }

        public Builder webpageUrl(String webpageUrl) {
            this._webpageUrl = ArgChecks.argNotNull("webpageUrl", webpageUrl);
            return this;
        }

        public Builder deferredIterations(int deferredIterations) {
            this._deferredIterations = deferredIterations;
            return this;
        }

        public Builder id(String domain, String category, String name) {
            return this.id(new PluginId(domain, category, name));
        }

        public Builder id(PluginId id) {
            this._id = ArgChecks.argNotNull("id", id);
            return this;
        }

        public Builder license(String license) {
            this._license = ArgChecks.argNotEmpty("license", license);
            return this;
        }

        public Builder resources(PluginResources resources) {
            this._resources = ArgChecks.argNotNull("resources", resources);
            return this;
        }

        public PluginInfo build() {
            return new PluginInfo(this._type, this._name, this._pluginVersion, this._description, this._author, this._maturityLevel, this._hqlMatcher, this._webpageUrl, this._deferredIterations, this._id, this._license, this._resources);
        }
    }
}

