/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.ep.shade.io.grpc.internal;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.hansken.ep.shade.com.google.common.base.Preconditions;
import org.hansken.ep.shade.com.google.common.base.Stopwatch;
import org.hansken.ep.shade.io.grpc.InternalServiceProviders;
import org.hansken.ep.shade.io.grpc.NameResolver;
import org.hansken.ep.shade.io.grpc.NameResolverProvider;
import org.hansken.ep.shade.io.grpc.internal.BackoffPolicyRetryScheduler;
import org.hansken.ep.shade.io.grpc.internal.DnsNameResolver;
import org.hansken.ep.shade.io.grpc.internal.ExponentialBackoffPolicy;
import org.hansken.ep.shade.io.grpc.internal.GrpcUtil;
import org.hansken.ep.shade.io.grpc.internal.RetryingNameResolver;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";

    @Override
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new RetryingNameResolver(new DnsNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader())), new BackoffPolicyRetryScheduler(new ExponentialBackoffPolicy.Provider(), args.getScheduledExecutorService(), args.getSynchronizationContext()), args.getSynchronizationContext());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    public int priority() {
        return 5;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }
}

