/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.main;

import java.nio.file.Path;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginClient;
import org.hansken.plugin.extraction.test.RemoteExtractionPluginFlits;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

public final class StandaloneFlitsTest
extends RemoteExtractionPluginFlits {
    private static Path _testPath;
    private static Path _resultPath;
    private static boolean _regenerate;
    private static String _host;
    private static int _port;
    private static String _pattern;
    private static ExtractionPluginClient _client;

    static void setup(Path testPath, Path resultPath, boolean regenerate, String host, int port, String pattern) {
        _testPath = (Path)ArgChecks.argNotNull((String)"testPath", (Object)testPath);
        _resultPath = (Path)ArgChecks.argNotNull((String)"resultPath", (Object)resultPath);
        _regenerate = regenerate;
        _host = ArgChecks.argNotEmpty((String)"host", (String)host);
        _port = port;
        _pattern = pattern;
    }

    @BeforeAll
    static void init() throws Exception {
        _client = new ExtractionPluginClient(_host, _port);
    }

    @AfterAll
    static void destruct() throws InterruptedException {
        if (_client != null) {
            _client.close();
        }
    }

    @Override
    public String pattern() {
        return _pattern != null ? _pattern : super.pattern();
    }

    @Override
    public Path testPath() {
        return _testPath;
    }

    @Override
    public Path resultPath() {
        return _resultPath;
    }

    @Override
    protected ExtractionPluginClient pluginToTest() {
        return _client;
    }

    @Override
    public boolean regenerate() {
        return _regenerate;
    }
}

