/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.serialize;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.hansken.plugin.extraction.api.BatchSearchResult;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.api.SearchResult;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.HqlLiteHumanQueryParser;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcher;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.hansken.plugin.extraction.test.base.ProcessingUtil;

public class TestTraceSearcher
implements TraceSearcher {
    private final Path _tracePath;

    public TestTraceSearcher(Path tracePath) {
        this._tracePath = tracePath;
    }

    public SearchResult search(String query, int count) throws ExecutionException {
        SearchTrace[] matchingTraces = this.getAllSearchTraces(HqlLiteHumanQueryParser.parse((String)query, (String)VersionUtil.getApiVersion()));
        BatchSearchResult result = new BatchSearchResult((long)matchingTraces.length);
        result.setTraces(matchingTraces);
        return result;
    }

    private SearchTrace[] getAllSearchTraces(HqlMatcher matcher) throws ExecutionException {
        SearchTrace[] searchTraceArray;
        block8: {
            Stream<Path> files = Files.list(ProcessingUtil.getSearchTracesPath(this._tracePath));
            try {
                searchTraceArray = (SearchTrace[])files.filter(path -> ProcessingUtil.isFileWithExtension(path, "trace")).sorted().map(ProcessingUtil::searchTraceFromPath).filter(searchTrace -> searchTrace.getDataTypes().stream().anyMatch(dataType -> matcher.match((ImmutableTrace)searchTrace, dataType))).toArray(SearchTrace[]::new);
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ExecutionException(e);
                }
            }
            files.close();
        }
        return searchTraceArray;
    }
}

