package org.hansken.plugin.extraction.test.util;

import nl.minvenj.nfi.flits.api.Trace;

/**
 * Set of constants to be used and shared in the test framework implementation classes.
 */
public final class Constants {

    /**
     * Prefix for properties which are used to store data streams, in order to be able to retrieve
     * data streams from a {@link Trace FLITS API trace}.
     */
    public static final String DATA_STREAM_NAME_PREFIX = "$";

    /**
     * Prefix for properties which are used to store transformations, in order to be able to retrieve
     * transformations from a {@link Trace FLITS API trace}.
     */
    public static final String TRANSFORMATIONS_PREFIX = "#";

    /**
     * <b>Warning</b>: the default value should always be <code>false</code>.
     * <p>
     * <code>true</code> should only be used for testing purposes.
     */
    public static final boolean DEFAULT_VERBOSE_LOGGING_ENABLED = false;

    private Constants() {
    }
}
