/*
 * Copyright (c) 2021, Netherlands Forensic Institute
 * All rights reserved.
 */
package org.hansken.plugin.extraction.test.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public final class TestResourceUtil {

    private TestResourceUtil() {
    }

    public static Path getTestResource(final String relativePath) throws URISyntaxException {
        final URL url = Objects.requireNonNull(TestResourceUtil.class.getResource("/"));
        final File root = new File(url.toURI()).getParentFile().getParentFile();
        return Paths.get(root.toString(), "src", "test", "resources", relativePath);
    }

    public static String relativePathToWorkingDir(final Path pathToRelative) {
        final URI currentAbsolutePath = Paths.get("").toAbsolutePath().toUri();
        final URI relativeTestFile = currentAbsolutePath.relativize(pathToRelative.toUri());
        return relativeTestFile.toString();
    }
}
