package org.hansken.plugin.extraction.test;

import org.hansken.plugin.extraction.api.ExtractionPlugin;
import org.hansken.plugin.extraction.api.PluginType;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.test.base.DefaultExtractionPluginProcessor;

import nl.minvenj.nfi.flits.api.Flits;

/**
 * Base implementation of the {@link Flits} framework, for use with embedded
 * {@link ExtractionPlugin extraction plugins}.
 * <p>
 * See {@link DefaultExtractionPluginProcessor} for how all files pointed to by the
 * {@link #testPath()} are used as input for test cases.
 *
 * @see ExtractionPluginProcessor
 * @see ExtractionPluginProcessor#process(ClientTrace, ClientDataContext)
 */
public abstract class EmbeddedExtractionPluginFlits extends ExtractionPluginFlits {

    @Override
    protected PluginType pluginType() {
        return pluginToTest().pluginInfo().pluginType();
    }

    @Override
    public ExtractionPluginProcessor processor() {
        return DefaultExtractionPluginProcessor.embedded(pluginToTest(), isVerboseLoggingEnabled());
    }

    /**
     * The {@link ExtractionPlugin plugin} to run over te test set specified by {@link #testPath()}.
     *
     * @return the plugin to test
     */
    protected abstract ExtractionPlugin pluginToTest();
}
