package org.hansken.plugin.extraction.test;

import static org.hansken.plugin.extraction.runtime.grpc.client.HealthUtil.getHealthBlockingStub;
import static org.junit.jupiter.api.Assertions.assertEquals;

import static grpc.health.v1.HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING;

import org.hansken.plugin.extraction.api.ExtractionPlugin;
import org.hansken.plugin.extraction.api.PluginType;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginClient;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.test.base.DefaultExtractionPluginProcessor;
import org.junit.jupiter.api.Test;

import grpc.health.v1.HealthGrpc.HealthBlockingStub;
import nl.minvenj.nfi.flits.api.Flits;

/**
 * Base implementation of the {@link Flits} framework, for use with remote
 * {@link ExtractionPlugin extraction plugins}.
 * <p>
 * See {@link DefaultExtractionPluginProcessor} for how all files pointed to by the
 * {@link #testPath()} are used as input for test cases.
 *
 * @see ExtractionPluginProcessor
 * @see ExtractionPluginProcessor#process(ClientTrace, ClientDataContext)
 */
public abstract class RemoteExtractionPluginFlits extends ExtractionPluginFlits {

    @Override
    protected PluginType pluginType() {
        return pluginToTest().pluginInfo().pluginType();
    }

    @Override
    public ExtractionPluginProcessor processor() {
        return DefaultExtractionPluginProcessor.remote(pluginToTest(), isVerboseLoggingEnabled());
    }

    /**
     * The {@link ExtractionPlugin plugin} to run over te test set specified by {@link #testPath()}.
     *
     * @return the plugin to test
     */
    protected abstract ExtractionPluginClient pluginToTest();

    @Test
    public void healthCheck() {
        final HealthBlockingStub healthStub = getHealthBlockingStub(pluginToTest().getTarget());
        assertEquals(SERVING, healthStub.check(null).getStatus());
        assertEquals(SERVING, healthStub.watch(null).next().getStatus());
    }

    @Test
    public void assertServerIsRunning() {
        // simple test that asserts that the server is running. if the server is _not_ running,
        // FLITs messes up and does not load the test cases.

        // this test fails if the server is not running
        pluginToTest().pluginInfo();
    }
}
