package org.hansken.plugin.extraction.test.serialize;

import java.io.IOException;
import java.nio.file.Path;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;

import static org.hansken.plugin.extraction.test.serialize.Deserialize.extractDataType;

/**
 * Simple {@link ClientDataContext} which has a data type and an accompanying
 * {@link RandomAccessData data sequence}, used for the input of a Flits run.
 */
public class TestContext extends AbstractTestContext {

    private final String _dataType;
    private final RandomAccessData _data;

    /**
     * Create a new TestContext, which reads all required data.
     *
     * @param dataFile path to the data file
     * @throws IOException when the path does not exist
     */
    public TestContext(final Path dataFile) throws IOException {
        super(dataFile);
        _data = new RandomAccessFileData(dataFile.toFile());
        _dataType = extractDataType(dataFile);
    }

    @Override
    public String dataType() {
        return _dataType;
    }

    @Override
    public RandomAccessData data() {
        return _data;
    }
}
