/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.api.result;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsResult;
import nl.minvenj.nfi.flits.api.FlitsResultGenerator;
import nl.minvenj.nfi.flits.api.FlitsResultValidator;

public final class ThrowableResult
implements FlitsResult {
    private final Throwable _throwable;
    private final String _description;
    private final String _factoryName;

    public ThrowableResult(Throwable throwable) {
        this(throwable, null);
    }

    public ThrowableResult(Throwable throwable, String description) {
        this(throwable, description, null);
    }

    public ThrowableResult(Throwable throwable, String description, String factoryName) {
        this._throwable = ArgChecks.argNotNull("throwable", throwable);
        this._description = description;
        this._factoryName = factoryName;
    }

    public static ThrowableResult forFactory(Throwable throwable, String factoryName) {
        return new ThrowableResult(throwable, null, factoryName);
    }

    public Throwable throwable() {
        return this._throwable;
    }

    public Optional<String> factoryName() {
        return Optional.ofNullable(this._factoryName);
    }

    public Optional<String> description() {
        return Optional.ofNullable(this._description);
    }

    @Override
    public void validate(FlitsResultValidator validator, Path inputPath) throws IOException {
        validator.validate(this, inputPath);
    }

    @Override
    public void generate(FlitsResultGenerator generator, Path outputPath) throws IOException {
        generator.generate(this, outputPath);
    }
}

