/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hansken.plugin.extraction.api.DataWriter;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.hansken.plugin.extraction.util.ThrowingConsumer;

public interface Trace
extends ImmutableTrace {
    public Trace addType(String var1);

    public Trace set(String var1, Object var2);

    default public Trace addTracelet(final String type, Consumer<TraceletBuilder> callback) {
        ArgChecks.argNotEmpty("type", type);
        ArgChecks.argNotNull("callback", callback);
        final ArrayList<TraceletProperty> properties = new ArrayList<TraceletProperty>();
        callback.accept(new TraceletBuilder(){

            @Override
            public TraceletBuilder set(String name, Object value) {
                String prefix = type + ".";
                String fqn = name.startsWith(prefix) ? name : prefix + name;
                properties.add(new TraceletProperty(fqn, value));
                return this;
            }
        });
        return this.addTracelet(new Tracelet(type, properties));
    }

    @Deprecated
    public Trace addTracelet(Tracelet var1);

    public Trace setData(String var1, DataWriter var2) throws IOException;

    default public Trace setData(String dataType, DataTransformation ... transformations) {
        return this.setData(dataType, Arrays.asList(transformations));
    }

    public Trace setData(String var1, List<DataTransformation> var2);

    default public Trace setData(String dataType, InputStream stream) throws IOException {
        ArgChecks.argNotNull("dataType", dataType);
        ArgChecks.argNotNull("stream", stream);
        return this.setData(dataType, stream::transferTo);
    }

    public Trace newChild(String var1, ThrowingConsumer<Trace, IOException> var2) throws IOException;

    public static class Tracelet {
        private final String _name;
        private final List<TraceletProperty> _value;

        public Tracelet(String name, List<TraceletProperty> value) {
            this._name = name;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public List<TraceletProperty> getValue() {
            return this._value;
        }
    }

    public static interface TraceletBuilder {
        public TraceletBuilder set(String var1, Object var2);
    }

    public static class TraceletProperty {
        private final String _name;
        private final Object _value;

        public TraceletProperty(String name, Object value) {
            this._name = name;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public Object getValue() {
            return this._value;
        }
    }
}

