/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

class Version
implements Comparable<Version> {
    private final int _majorVersion;
    private final int _minorVersion;
    private final int _patchVersion;
    private final String _subVersion;

    Version(int majorVersion, int minorVersion, int patchVersion) {
        this(majorVersion, minorVersion, patchVersion, "");
    }

    Version(int majorVersion, int minorVersion, int patchVersion, String subVersion) {
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        this._patchVersion = patchVersion;
        this._subVersion = subVersion;
    }

    static Version fromString(String version) {
        String[] versionParts = version.split("-|\\+", 2);
        String[] semver = versionParts[0].split("\\.");
        if (semver.length != 3) {
            throw new IllegalArgumentException("got invalid version, not in the form major.minor.patch[-subversion], got: " + version);
        }
        String subVersion = versionParts.length > 1 ? versionParts[1] : "";
        try {
            int majorVersion = Integer.parseInt(semver[0]);
            int minorVersion = Integer.parseInt(semver[1]);
            int patchVersion = Integer.parseInt(semver[2]);
            return new Version(majorVersion, minorVersion, patchVersion, subVersion);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("got invalid version, could not parse numbers from: " + version);
        }
    }

    int getMajorVersion() {
        return this._majorVersion;
    }

    int getMinorVersion() {
        return this._minorVersion;
    }

    int getPatchVersion() {
        return this._patchVersion;
    }

    String getSubVersion() {
        return this._subVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._majorVersion;
        result = 31 * result + this._minorVersion;
        result = 31 * result + this._patchVersion;
        result = 31 * result + (this._subVersion == null ? 0 : this._subVersion.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this._majorVersion != other._majorVersion) {
            return this._majorVersion < other._majorVersion ? 1 : -1;
        }
        if (this._minorVersion != other._minorVersion) {
            return this._minorVersion < other._minorVersion ? 1 : -1;
        }
        if (this._patchVersion != other._patchVersion) {
            return this._patchVersion < other._patchVersion ? 1 : -1;
        }
        return 0;
    }

    public boolean isHigherOrEqualTo(Version other) {
        return this.compareTo(other) <= 0;
    }

    public String toString() {
        if (this._subVersion.isEmpty()) {
            return this._majorVersion + "." + this._minorVersion + "." + this._patchVersion;
        }
        return this._majorVersion + "." + this._minorVersion + "." + this._patchVersion + "-" + this._subVersion;
    }
}

