/*
 * Copyright (c) 2021, Netherlands Forensic Institute
 * All rights reserved.
 */
package nl.minvenj.nfi.flits.serialize;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class MapUtil {
    private MapUtil() {
    }

    static Map<String, Object> mapMap(final Map<Property, Object> properties, final int depth) {
        final Map<String, Object> mapOfMaps = new HashMap<>();
        final Set<Property> mapProperties = properties.keySet();

        final Set<String> mapNames = mapProperties.stream()
            .map(MapUtil::getMapNamePrefix)
            .collect(Collectors.toSet());

        for (final String name : mapNames) {
            final String elementName = (depth == 0 ? "ROOT_ELEMENT." : "") + name; // Property::parse needs a dot separated property
            final Map<Property, Object> nestedMap = new HashMap<>();
            final Map<String, Object> mapEntries = new HashMap<>();
            for (Property property : mapProperties) {
                if (property.fullName().startsWith(name + ".")) {
                    final String mapPostfixName = getMapNamePostfix(property);
                    if (mapPostfixName.contains(".")) { // if nested map?
                        nestedMap.put(Property.parse(mapPostfixName), properties.get(property));
                    }
                    else {
                        mapEntries.put(mapPostfixName, properties.get(property));
                    }
                }
            }

            if (!mapEntries.isEmpty()) { // last in line
                mapOfMaps.put(elementName, mapEntries);
            }
            if (!nestedMap.isEmpty()) {
                mapOfMaps.put(elementName, mapMap(nestedMap, depth + 1));
            }
        }

        return mapOfMaps;
    }

    private static String getMapNamePrefix(final Property property) {
        final int endIndex = property.fullName().indexOf(".");
        return property.fullName().substring(0, endIndex);
    }

    static String getMapNamePostfix(final Property property) {
        final int beginIndex = property.fullName().indexOf(".");
        return property.fullName().substring(beginIndex + 1);
    }
}
