package org.hansken.plugin.extraction.test.serialize;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;

import org.hansken.plugin.extraction.api.RandomAccessData;

/**
 * A {@link RandomAccessData} implementation which reads from an in-memory
 * byte array. Closing it has the effect of removing the reference to the array.
 * <p>
 * <strong>Note:</strong> this implementation is not thread-safe.
 */
public class RandomAccessFileData implements RandomAccessData {

    private final RandomAccessFile _file;

    /**
     * Create a new instance reading from given file.
     *
     * @param file the file to read data from
     * @throws FileNotFoundException if the file does not exist
     */
    public RandomAccessFileData(final File file) throws FileNotFoundException {
        _file = new RandomAccessFile(file, "r");
    }

    @Override
    public void close() throws IOException {
        _file.close();
    }

    @Override
    public long size() {
        try {
            return _file.length();
        }
        catch (final IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long position() {
        try {
            return _file.getFilePointer();
        }
        catch (final IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void seek(final long position) throws IOException {
        _file.seek(position);
    }

    @Override
    public int read(final byte[] buffer, final int offset, final int count) throws IOException {
        return _file.read(buffer, offset, count);
    }
}
