/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.util;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public final class FlitsUtil {
    private FlitsUtil() {
    }

    public static Path projectRootPath(Class<?> clazz) {
        try {
            Path targetClasses = Paths.get(clazz.getResource("/").toURI());
            return Paths.get(targetClasses.getParent().getParent().toUri());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static File srcFile(String path) {
        return FlitsUtil.getSourceFile(path);
    }

    public static Path srcPath(String path) {
        return FlitsUtil.getSourceFile(path).toPath();
    }

    public static <T> void assertEquals(Stream<T> expected, Stream<T> actual) {
        Iterator expectedStream = expected.iterator();
        Iterator actualStream = actual.iterator();
        while (expectedStream.hasNext() && actualStream.hasNext()) {
            Assertions.assertEquals(expectedStream.next(), actualStream.next());
        }
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)expectedStream.hasNext(), (String)"The expected Stream was longer than the actual Stream"), () -> Assertions.assertFalse((boolean)actualStream.hasNext(), (String)"The actual Stream json was longer than the expected Stream")});
    }

    private static File getSourceFile(String path) {
        if (Paths.get(path, new String[0]).isAbsolute()) {
            return new File(path);
        }
        try {
            File root = new File(FlitsUtil.class.getResource("/").toURI()).getParentFile().getParentFile();
            File result = new File(root, "src/test/resources");
            return new File(result, path);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)"Unable to determine the resource URI for test files.");
        }
    }
}

