/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test;

import nl.minvenj.nfi.flits.api.Flits;
import org.hansken.plugin.extraction.api.PluginType;

public abstract class ExtractionPluginFlits
extends Flits {
    private static final String DATA_STREAM_INPUT_PATTERN = "regex:.*(?<!\\.trace|\\.flits\\.gz)$";
    private static final String TRACE_INPUT_PATTERN = "regex:.*\\.trace$";

    protected abstract PluginType pluginType();

    @Override
    public String pattern() {
        switch (this.pluginType()) {
            case EXTRACTION_PLUGIN: 
            case DEFERRED_EXTRACTION_PLUGIN: {
                return DATA_STREAM_INPUT_PATTERN;
            }
            case META_EXTRACTION_PLUGIN: {
                return TRACE_INPUT_PATTERN;
            }
        }
        throw new AssertionError((Object)("unknown type of plugin: " + this.pluginType()));
    }

    @Override
    public String resultFileSuffix() {
        return "." + this.processor().name() + ".trace";
    }

    protected boolean isVerboseLoggingEnabled() {
        return false;
    }
}

