/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Objects;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.DataStreamMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcher;

class DataHqlMatcher
implements HqlMatcher {
    private final DataStreamMatcher _matcher;
    private final String _property;

    DataHqlMatcher(HqlMatcher matcher) {
        if (!(matcher instanceof DataStreamMatcher)) {
            throw new UnsupportedOperationException();
        }
        this._matcher = (DataStreamMatcher)((Object)matcher);
        this._property = matcher.property();
    }

    @Override
    public boolean match(ImmutableTrace trace, String dataType) {
        String data = DataHqlMatcher.data(dataType, this._property);
        return this._matcher.matchDataStream(trace, data);
    }

    private static String data(String dataType, String postfix) {
        return "data." + dataType + "." + postfix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataHqlMatcher that = (DataHqlMatcher)o;
        return Objects.equals(this._matcher, that._matcher) && Objects.equals(this._property, that._property);
    }

    public int hashCode() {
        return Objects.hash(this._matcher, this._property);
    }
}

