/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.math.BigDecimal;
import java.util.Objects;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.DataStreamMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcher;

class NumberRangeHqlMatcher
implements HqlMatcher,
DataStreamMatcher {
    private final BigDecimal _min;
    private final BigDecimal _max;
    private final boolean _includesMin;
    private final boolean _includesMax;
    private final boolean _fullMatch;
    private final String _property;

    NumberRangeHqlMatcher(BigDecimal min, BigDecimal max, boolean includesMax, boolean fullMatch, String property) {
        this._min = min;
        this._max = max;
        this._includesMin = true;
        this._includesMax = includesMax;
        this._fullMatch = fullMatch;
        this._property = property;
    }

    NumberRangeHqlMatcher(BigDecimal min, BigDecimal max, boolean includesMin, boolean includesMax, boolean fullMatch, String property) {
        this._min = min;
        this._max = max;
        this._includesMin = includesMin;
        this._includesMax = includesMax;
        this._fullMatch = fullMatch;
        this._property = property;
    }

    @Override
    public boolean match(ImmutableTrace trace, String dataType) {
        return this.matchDataStream(trace, this._property);
    }

    @Override
    public boolean matchDataStream(ImmutableTrace trace, String traceDataProperty) {
        if (!trace.properties().contains(traceDataProperty)) {
            return false;
        }
        BigDecimal value = new BigDecimal(Objects.toString(trace.get(traceDataProperty)));
        boolean result = true;
        if (this._min != null) {
            result = this._includesMin ? (result &= value.compareTo(this._min) >= 0) : (result &= value.compareTo(this._min) > 0);
        }
        if (this._max != null) {
            result = this._includesMax ? (result &= value.compareTo(this._max) <= 0) : (result &= value.compareTo(this._max) < 0);
        }
        return result;
    }

    @Override
    public String property() {
        return this._property;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumberRangeHqlMatcher that = (NumberRangeHqlMatcher)o;
        return this._includesMin == that._includesMin && this._includesMax == that._includesMax && this._fullMatch == that._fullMatch && Objects.equals(this._min, that._min) && Objects.equals(this._max, that._max) && Objects.equals(this._property, that._property);
    }

    public int hashCode() {
        return Objects.hash(this._min, this._max, this._includesMin, this._includesMax, this._fullMatch, this._property);
    }
}

