/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.AllHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.AndHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.DataHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.DataTypeHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.NoneHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.NotHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.NumberRangeHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.OrHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.TermHqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.TypeHqlMatcher;
import org.hansken.plugin.extraction.util.ArgChecks;

public final class QueryBuilders {
    private static final AllHqlMatcher ALL_QUERY = new AllHqlMatcher();
    private static final NoneHqlMatcher NONE_QUERY = new NoneHqlMatcher();

    private QueryBuilders() {
    }

    public static AllHqlMatcher all() {
        return ALL_QUERY;
    }

    public static TermHqlMatcher term(String value, boolean fullMatch, String ... properties) {
        ArgChecks.argNotNull((String)"value", (Object)value);
        ArgChecks.argNotEmpty((String)"properties", (Object[])properties);
        return new TermHqlMatcher(properties[0], fullMatch, value);
    }

    public static TermHqlMatcher term(String value, String ... properties) {
        return QueryBuilders.term(value, false, properties);
    }

    public static DataHqlMatcher data(HqlMatcher matcher) {
        ArgChecks.argNotNull((String)"matcher", (Object)matcher);
        return new DataHqlMatcher(matcher);
    }

    public static DataTypeHqlMatcher dataType(String value, boolean fullMatch) {
        ArgChecks.argNotEmpty((String)"value", (String)value);
        return new DataTypeHqlMatcher(value, fullMatch);
    }

    public static DataTypeHqlMatcher dataType(String value) {
        return QueryBuilders.dataType(value, false);
    }

    public static TypeHqlMatcher type(List<HqlMatcher> matchers) {
        ArgChecks.argNotEmpty((String)"matchers", matchers);
        ArgChecks.argsIsType((String)"matchers", matchers, TermHqlMatcher.class);
        return new TypeHqlMatcher(new ArrayList<HqlMatcher>(matchers));
    }

    public static NumberRangeHqlMatcher range(BigDecimal min, BigDecimal max, boolean includesMin, boolean includesMax, boolean fullMatch, String ... properties) {
        ArgChecks.argNotAllNull((String)"min, max", (Object[])new Object[]{min, max});
        ArgChecks.argNotEmpty((String)"properties", (Object[])properties);
        return new NumberRangeHqlMatcher(min, max, includesMin, includesMax, fullMatch, properties[0]);
    }

    public static NumberRangeHqlMatcher range(BigDecimal min, BigDecimal max, boolean includesMax, boolean fullMatch, String ... properties) {
        return QueryBuilders.range(min, max, true, includesMax, fullMatch, properties);
    }

    public static NumberRangeHqlMatcher range(String min, String max, boolean includesMin, boolean includesMax, boolean fullMatch, String ... properties) {
        return QueryBuilders.range(QueryBuilders.toBigDecimal(min), QueryBuilders.toBigDecimal(max), includesMin, includesMax, fullMatch, properties);
    }

    public static NumberRangeHqlMatcher range(String min, String max, boolean includesMax, boolean fullMatch, String ... properties) {
        return QueryBuilders.range(min, max, true, includesMax, fullMatch, properties);
    }

    public static AndHqlMatcher and(HqlMatcher ... queries) {
        ArgChecks.argNotNull((String)"queries", (Object)queries);
        return new AndHqlMatcher(queries);
    }

    public static OrHqlMatcher or(HqlMatcher ... queries) {
        ArgChecks.argNotNull((String)"queries", (Object)queries);
        return new OrHqlMatcher(queries);
    }

    public static NotHqlMatcher not(HqlMatcher matcher) {
        ArgChecks.argNotNull((String)"query", (Object)matcher);
        return new NotHqlMatcher(matcher);
    }

    private static BigDecimal toBigDecimal(String min) {
        if (min == null) {
            return null;
        }
        return new BigDecimal(min);
    }
}

