/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.ep.shade.com.google.common.collect;

import org.hansken.ep.shade.com.google.common.annotations.GwtCompatible;
import org.hansken.ep.shade.com.google.common.collect.AbstractMapBasedMultiset;
import org.hansken.ep.shade.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.hansken.ep.shade.com.google.common.collect.Iterables;
import org.hansken.ep.shade.com.google.common.collect.Multisets;
import org.hansken.ep.shade.com.google.common.collect.ObjectCountHashMap;
import org.hansken.ep.shade.com.google.common.collect.ObjectCountLinkedHashMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    public static <E> LinkedHashMultiset<E> create() {
        return LinkedHashMultiset.create(3);
    }

    public static <E> LinkedHashMultiset<E> create(int distinctElements) {
        return new LinkedHashMultiset<E>(distinctElements);
    }

    public static <E> LinkedHashMultiset<E> create(Iterable<? extends E> elements) {
        LinkedHashMultiset<E> multiset = LinkedHashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    LinkedHashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    ObjectCountHashMap<E> newBackingMap(int distinctElements) {
        return new ObjectCountLinkedHashMap(distinctElements);
    }
}

