/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.runtime.grpc.client.StreamTransferState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataStreamTransferStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(DataStreamTransferStateManager.class);
    private final Map<String, StreamTransferState> _transfers = new HashMap<String, StreamTransferState>();
    private final Trace _trace;
    private final ExecutorService _executor;

    DataStreamTransferStateManager(Trace trace, ExecutorService executor) {
        this._trace = trace;
        this._executor = executor;
    }

    void start(String dataType) throws IOException {
        if (this._transfers.containsKey(dataType)) {
            throw new IllegalStateException("data stream transfer started for data stream '" + dataType + "', but was already started");
        }
        StreamTransferState transfer = StreamTransferState.create(this._trace, dataType, this._executor);
        transfer.setup();
        transfer.start();
        this._transfers.put(dataType, transfer);
    }

    StreamTransferState get(String dataType) {
        this.assertStreamStarted(dataType);
        return this._transfers.get(dataType);
    }

    void finish(String dataType) throws IOException {
        this.assertStreamStarted(dataType);
        this._transfers.remove(dataType).finish();
    }

    void assertStreamStarted(String dataType) {
        if (!this._transfers.containsKey(dataType)) {
            throw new IllegalStateException("data stream transfer not started for datastream '" + dataType + "'");
        }
    }

    void finishAll() {
        for (String dataStream : this._transfers.keySet()) {
            try {
                this._transfers.remove(dataStream).finish();
            }
            catch (Exception e) {
                LOG.error("error while trying to shut down transfer for datastream '{}'", (Object)dataStream, (Object)e);
            }
        }
    }
}

